/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    protected long maxIdle;
    protected long lastUsed;
    protected long lifespan;
    protected long created;

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long currentTimeMillis) {
        this(key, value, maxIdle, lifespan, currentTimeMillis, currentTimeMillis);
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        this(key, value, null, maxIdle, lifespan, lastUsed, created);
    }

    protected TransientMortalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key, value, internalMetadata);
        this.maxIdle = maxIdle;
        this.lifespan = lifespan;
        this.created = created;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    TransientMortalCacheEntry(MarshallableObject<?> wrappedKey, MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, long maxIdle, long lastUsed, long lifespan, long created) {
        super(wrappedKey, wrappedValue, internalMetadata);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
        this.lifespan = lifespan;
        this.created = created;
    }

    @Override
    @ProtoField(value=4)
    public long getLifespan() {
        return this.lifespan;
    }

    @Override
    @ProtoField(value=5)
    public long getCreated() {
        return this.created;
    }

    @Override
    @ProtoField(value=6)
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    @ProtoField(value=7)
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new TransientMortalCacheValue(this.value, this.internalMetadata, this.created, this.lifespan, this.maxIdle, this.lastUsed);
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.lifespan).maxIdle(this.maxIdle).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public TransientMortalCacheEntry clone() {
        return (TransientMortalCacheEntry)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", lastUsed=").append(this.lastUsed);
        builder.append(", maxIdle=").append(this.maxIdle);
        builder.append(", created=").append(this.created);
        builder.append(", lifespan=").append(this.lifespan);
    }
}

