/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.commons.util.Features;
import org.infinispan.configuration.global.CacheContainerConfiguration;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.GlobalTracingConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalConfiguration {
    private final Map<Class<?>, ?> modules;
    private final ClassLoader cl;
    private final CacheContainerConfiguration cacheContainerConfiguration;
    private final Features features;

    GlobalConfiguration(CacheContainerConfiguration cacheContainerConfiguration, List<?> modules, ClassLoader cl, Features features) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
        HashMap moduleMap = new HashMap();
        for (Object module : modules) {
            moduleMap.put(module.getClass(), module);
        }
        this.modules = Map.copyOf(moduleMap);
        this.cl = cl;
        this.features = features;
    }

    CacheContainerConfiguration cacheContainer() {
        return this.cacheContainerConfiguration;
    }

    public boolean statistics() {
        return this.cacheContainerConfiguration.statistics();
    }

    public ThreadPoolConfiguration expirationThreadPool() {
        return this.cacheContainerConfiguration.expirationThreadPool();
    }

    public ThreadPoolConfiguration listenerThreadPool() {
        return this.cacheContainerConfiguration.listenerThreadPool();
    }

    public ThreadPoolConfiguration nonBlockingThreadPool() {
        return this.cacheContainerConfiguration.nonBlockingThreadPool();
    }

    public ThreadPoolConfiguration blockingThreadPool() {
        return this.cacheContainerConfiguration.blockingThreadPool();
    }

    public GlobalTracingConfiguration tracing() {
        return this.cacheContainerConfiguration.tracing();
    }

    public GlobalMetricsConfiguration metrics() {
        return this.cacheContainerConfiguration.metrics();
    }

    public GlobalJmxConfiguration jmx() {
        return this.cacheContainerConfiguration.jmx();
    }

    public String cacheManagerName() {
        return this.cacheContainerConfiguration.cacheManagerName();
    }

    public TransportConfiguration transport() {
        return this.cacheContainerConfiguration.transport();
    }

    public GlobalSecurityConfiguration security() {
        return this.cacheContainerConfiguration.security();
    }

    public SerializationConfiguration serialization() {
        return this.cacheContainerConfiguration.serialization();
    }

    public ShutdownConfiguration shutdown() {
        return this.cacheContainerConfiguration.shutdown();
    }

    public GlobalStateConfiguration globalState() {
        return this.cacheContainerConfiguration.globalState();
    }

    public String nonBlockingThreadPoolName() {
        return this.cacheContainer().nonBlockingExecutor();
    }

    public String listenerThreadPoolName() {
        return this.cacheContainer().listenerExecutor();
    }

    public String expirationThreadPoolName() {
        return this.cacheContainer().expirationExecutor();
    }

    public String blockingThreadPoolName() {
        return this.cacheContainer().blockingExecutor();
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.modules.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.modules;
    }

    public ClassLoader classLoader() {
        return this.cl;
    }

    public Optional<String> defaultCacheName() {
        return Optional.ofNullable(this.cacheContainerConfiguration.defaultCacheName());
    }

    public Features features() {
        return this.features;
    }

    public boolean isClustered() {
        return this.transport().transport() != null;
    }

    public boolean isZeroCapacityNode() {
        return this.cacheContainerConfiguration.getZeroCapacityNode();
    }

    public String toString() {
        return "GlobalConfiguration{, modules=" + String.valueOf(this.modules) + ", cl=" + String.valueOf(this.cl) + "}";
    }
}

