/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractPersistenceConfigurationChildBuilder;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.util.logging.Log;

public abstract class AbstractStoreConfigurationBuilder<T extends StoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractPersistenceConfigurationChildBuilder
implements StoreConfigurationBuilder<T, S> {
    protected final AttributeSet attributes;
    protected final AsyncStoreConfigurationBuilder<S> async;

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this);
    }

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes, AttributeSet asyncAttributeSet) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this, asyncAttributeSet);
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    @Deprecated(forRemoval=true, since="14.0")
    public S fetchPersistentState(boolean b) {
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.READ_ONLY).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S writeOnly(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.WRITE_ONLY).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public S properties(Properties properties) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)new TypedProperties((Map)properties));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)properties);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S withProperties(Properties props) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)props));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S preload(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S shared(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SHARED).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S transactional(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S maxBatchSize(int maxBatchSize) {
        this.attributes.attribute(AbstractStoreConfiguration.MAX_BATCH_SIZE).set((Object)maxBatchSize);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S segmented(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
        this.validateStoreAttributes();
    }

    private void validateStoreAttributes() {
        this.async.validate();
        boolean shared = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.SHARED).get();
        boolean preload = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).get();
        boolean purgeOnStartup = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).get();
        boolean transactional = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).get();
        boolean readOnly = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.READ_ONLY).get();
        boolean writeOnly = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.WRITE_ONLY).get();
        ConfigurationBuilder builder = this.getBuilder();
        if (purgeOnStartup && preload) {
            throw Log.CONFIG.preloadAndPurgeOnStartupConflict();
        }
        if (readOnly && writeOnly) {
            throw Log.CONFIG.storeBothReadAndWriteOnly();
        }
        if (readOnly && (purgeOnStartup || shared || this.persistence().passivation())) {
            throw Log.CONFIG.storeReadOnlyExceptions();
        }
        if (writeOnly && preload) {
            throw Log.CONFIG.storeWriteOnlyExceptions();
        }
        if (shared && !builder.clustering().cacheMode().isClustered()) {
            throw Log.CONFIG.sharedStoreWithLocalCache();
        }
        if (transactional && !builder.transaction().transactionMode().isTransactional()) {
            throw Log.CONFIG.transactionalStoreInNonTransactionalCache();
        }
        if (transactional && builder.persistence().passivation()) {
            throw Log.CONFIG.transactionalStoreInPassivatedCache();
        }
    }

    public Builder<?> read(T template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.async.read(template.async(), combine);
        return this;
    }

    public String toString() {
        return "AbstractStoreConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + ", async=" + String.valueOf(this.async) + "]";
    }
}

