/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=28)
public class RemoveCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    private boolean returnEntry = false;
    private transient boolean nonExistent = false;
    protected transient boolean successful = true;
    protected Metadata metadata;
    protected ValueMatcher valueMatcher;
    private PrivateMetadata internalMetadata;
    protected Object value;

    public RemoveCommand(ByteString cacheName, Object key, Object value, boolean returnEntry, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(cacheName, key, segment, flagsBitSet, commandInvocationId);
        this.setValue(value);
        this.valueMatcher = value != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
        this.returnEntry = returnEntry;
    }

    @ProtoFactory
    RemoveCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, CommandInvocationId commandInvocationId, MarshallableObject<?> wrappedValue, MarshallableObject<Metadata> wrappedMetadata, ValueMatcher valueMatcher, PrivateMetadata internalMetadata, boolean returnEntryNecessary) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment, commandInvocationId);
        this.value = MarshallableObject.unwrap(wrappedValue);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.valueMatcher = valueMatcher;
        this.internalMetadata = internalMetadata;
        this.returnEntry = returnEntryNecessary;
    }

    @ProtoField(number=7, name="value")
    protected MarshallableObject<?> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(number=8, name="metadata")
    protected MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=9)
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    @ProtoField(value=10)
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }

    @ProtoField(value=11)
    public boolean isReturnEntryNecessary() {
        return this.returnEntry;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    @Override
    public boolean shouldReplicate(InvocationContext ctx, boolean requireReplicateIfRemote) {
        if (!this.isSuccessful()) {
            return false;
        }
        return !this.nonExistent || this.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP | FlagBitSets.SKIP_CACHE_LOAD) || requireReplicateIfRemote && (ctx == null || !ctx.isOriginLocal());
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RemoveCommand{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", returnEntry=" + this.returnEntry + ", metadata=" + this.metadata + ", internalMetadata=" + this.internalMetadata + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.value != null;
    }

    public void nonExistant() {
        this.nonExistent = true;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.isConditional() || !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.PRIMARY : VisitableCommand.LoadType.DONT_LOAD;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

