/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1058)
public class ClusteredGetAllCommand<K, V>
extends BaseClusteredReadCommand {
    private static final Log log = LogFactory.getLog(ClusteredGetAllCommand.class);
    private List<?> keys;
    private GlobalTransaction gtx;

    public ClusteredGetAllCommand(ByteString cacheName, List<?> keys, long flags, GlobalTransaction gtx) {
        super(cacheName, -1, flags);
        this.keys = keys;
        this.gtx = gtx;
    }

    @ProtoFactory
    ClusteredGetAllCommand(ByteString cacheName, int topologyId, long flagsWithoutRemote, MarshallableList<?> wrappedKeys, GlobalTransaction globalTransaction) {
        super(cacheName, topologyId, flagsWithoutRemote);
        this.keys = MarshallableList.unwrap(wrappedKeys);
        this.gtx = globalTransaction;
    }

    @ProtoField(number=4, name="keys")
    MarshallableList<?> getWrappedKeys() {
        return MarshallableList.create(this.keys);
    }

    @ProtoField(value=5)
    GlobalTransaction getGlobalTransaction() {
        return this.gtx;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (!EnumUtil.containsAny((long)this.flags, (long)FlagBitSets.FORCE_WRITE_LOCK)) {
            return this.invokeGetAll(componentRegistry);
        }
        return componentRegistry.getCommandsFactory().buildLockControlCommand(this.keys, this.flags, this.gtx).invokeAsync(componentRegistry).thenCompose(o -> this.invokeGetAll(componentRegistry));
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    private CompletionStage<Object> invokeGetAll(ComponentRegistry cr) {
        GetAllCommand command = cr.getCommandsFactory().buildGetAllCommand(this.keys, this.flags, true);
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = cr.getInvocationContextFactory().running().createRemoteInvocationContextForCommand(command, this.getOrigin());
        CompletableFuture<Object> future = cr.getInterceptorChain().running().invokeAsync(invocationContext, command);
        return future.thenApply(rv -> {
            if (log.isTraceEnabled()) {
                log.trace("Found: " + String.valueOf(rv));
            }
            if (rv == null || rv instanceof Response) {
                return rv;
            }
            Map map = (Map)rv;
            InternalCacheValue[] values = new InternalCacheValue[this.keys.size()];
            int i = 0;
            for (Object key : this.keys) {
                InternalCacheValue value;
                CacheEntry entry = (CacheEntry)map.get(key);
                if (entry == null) {
                    value = null;
                } else if (entry instanceof InternalCacheEntry) {
                    value = ((InternalCacheEntry)entry).toInternalCacheValue();
                } else {
                    value = cr.getInternalEntryFactory().running().createValue(entry);
                    value.setInternalMetadata(entry.getInternalMetadata());
                }
                values[i++] = value;
            }
            return values;
        });
    }

    public List<?> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetAllCommand that = (ClusteredGetAllCommand)o;
        return Objects.equals(this.keys, that.keys) && Objects.equals(this.gtx, that.gtx);
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.gtx);
    }

    @Override
    public String toString() {
        return "ClusteredGetAllCommand{keys=" + String.valueOf(this.keys) + ", flags=" + EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class) + ", topologyId=" + this.topologyId + "}";
    }
}

