/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyInfo;

@ProtoTypeId(value=1103)
public class IracStateResponseCommand
extends BaseIracCommand {
    @ProtoField(value=2)
    final Collection<State> stateCollection;

    @ProtoFactory
    IracStateResponseCommand(ByteString cacheName, ArrayList<State> stateCollection) {
        super(cacheName);
        this.stateCollection = stateCollection;
    }

    public IracStateResponseCommand(ByteString cacheName, int capacity) {
        super(cacheName);
        this.stateCollection = new ArrayList<State>(capacity);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        IracManager manager = registry.getIracManager().running();
        for (State state : this.stateCollection) {
            state.apply(manager);
        }
        return CompletableFutures.completedNull();
    }

    public void add(IracManagerKeyInfo keyInfo, IracMetadata tombstone) {
        this.stateCollection.add(new State(keyInfo, tombstone));
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracStateResponseCommand{cacheName=" + String.valueOf(this.cacheName) + ", state=" + Util.toStr(this.stateCollection) + "}";
    }

    @Proto
    @ProtoTypeId(value=1104)
    public record State(IracManagerKeyInfo keyInfo, IracMetadata tombstone) {
        public State {
            Objects.requireNonNull(keyInfo);
        }

        void apply(IracManager manager) {
            manager.receiveState(this.keyInfo.getSegment(), this.keyInfo.getKey(), this.keyInfo.getOwner(), this.tombstone);
        }
    }
}

