/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commands.irac.IracTombstoneRemoteSiteCheckCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.responses.SuccessfulObjResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.irac.IracManager;

@ProtoTypeId(value=1109)
public class IracTombstoneCheckRequest
extends XSiteCacheRequest<IntSet> {
    private List<Object> keys;

    public IracTombstoneCheckRequest(ByteString cacheName, List<Object> keys) {
        super(cacheName);
        this.keys = keys;
    }

    @ProtoFactory
    IracTombstoneCheckRequest(ByteString cacheName, MarshallableList<Object> keys) {
        this(cacheName, MarshallableList.unwrap(keys));
    }

    @ProtoField(value=2)
    MarshallableList<Object> getKeys() {
        return MarshallableList.create(this.keys);
    }

    @Override
    protected CompletionStage<IntSet> invokeInLocalCache(String origin, ComponentRegistry registry) {
        LocalizedCacheTopology topology = registry.getDistributionManager().getCacheTopology();
        IracManager iracManager = registry.getIracManager().running();
        RpcManager rpcManager = registry.getRpcManager().running();
        RpcOptions rpcOptions = rpcManager.getSyncRpcOptions();
        int numberOfKeys = this.keys.size();
        HashMap<Address, IntSetResponseCollector> primaryOwnerKeys = new HashMap<Address, IntSetResponseCollector>(rpcManager.getMembers().size());
        IntSet toKeepIndexes = IntSets.concurrentSet((int)numberOfKeys);
        for (int index = 0; index < numberOfKeys; ++index) {
            Object key = this.keys.get(index);
            DistributionInfo dInfo = topology.getDistribution(key);
            if (dInfo.isPrimary()) {
                if (!iracManager.containsKey(key)) continue;
                toKeepIndexes.set(index);
                continue;
            }
            IntSetResponseCollector collector = primaryOwnerKeys.computeIfAbsent(dInfo.primary(), a -> new IntSetResponseCollector(numberOfKeys, toKeepIndexes));
            collector.add(index, key);
        }
        if (primaryOwnerKeys.isEmpty()) {
            return CompletableFuture.completedFuture(toKeepIndexes);
        }
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage((Object)toKeepIndexes);
        for (Map.Entry entry : primaryOwnerKeys.entrySet()) {
            IracTombstoneRemoteSiteCheckCommand cmd = new IracTombstoneRemoteSiteCheckCommand(this.cacheName, ((IntSetResponseCollector)entry.getValue()).getKeys());
            stage.dependsOn(rpcManager.invokeCommand((Address)entry.getKey(), (CacheRpcCommand)cmd, (ResponseCollector)entry.getValue(), rpcOptions));
        }
        return stage.freeze();
    }

    public String toString() {
        return "IracTombstoneCheckRequest{cacheName=" + String.valueOf(this.cacheName) + ", keys=" + this.keys.stream().map(Util::toStr).collect(Collectors.joining(",")) + "}";
    }

    private static class IntSetResponseCollector
    extends ValidSingleResponseCollector<Void> {
        private final List<Object> keys;
        private final int[] keyIndexes;
        private final IntSet globalToKeepIndexes;
        private int nextInsertPosition;

        private IntSetResponseCollector(int maxCapacity, IntSet globalToKeepIndexes) {
            this.keys = new ArrayList<Object>(maxCapacity);
            this.keyIndexes = new int[maxCapacity];
            this.globalToKeepIndexes = globalToKeepIndexes;
        }

        void add(int index, Object key) {
            assert (this.nextInsertPosition < this.keyIndexes.length);
            this.keys.add(key);
            this.keyIndexes[this.nextInsertPosition++] = index;
        }

        List<Object> getKeys() {
            return this.keys;
        }

        @Override
        protected Void withValidResponse(Address sender, ValidResponse response) {
            if (response instanceof SuccessfulObjResponse) {
                SuccessfulObjResponse rsp = (SuccessfulObjResponse)response;
                IntSet toKeep = (IntSet)rsp.getResponseValue();
                PrimitiveIterator.OfInt it = toKeep.iterator();
                while (it.hasNext()) {
                    int localPosition = it.nextInt();
                    assert (localPosition < this.keyIndexes.length);
                    this.globalToKeepIndexes.set(this.keyIndexes[localPosition]);
                }
            }
            return null;
        }

        @Override
        protected Void withException(Address sender, Exception exception) {
            this.markAllToKeep();
            return null;
        }

        @Override
        protected Void targetNotFound(Address sender) {
            this.markAllToKeep();
            return null;
        }

        private void markAllToKeep() {
            for (int index : this.keyIndexes) {
                this.globalToKeepIndexes.set(index);
            }
        }
    }
}

