/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

@ProtoTypeId(value=1249)
public class XSiteStateTransferRestartSendingCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;
    @ProtoField(value=3)
    final int topologyId;

    @ProtoFactory
    public XSiteStateTransferRestartSendingCommand(ByteString cacheName, String siteName, int topologyId) {
        super(cacheName);
        this.siteName = siteName;
        this.topologyId = topologyId;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        this.invokeLocal(registry.getXSiteStateTransferManager().running().getStateProvider());
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferRestartSendingCommand{siteName='" + this.siteName + "', topologyId=" + this.topologyId + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }

    public void invokeLocal(XSiteStateProvider provider) {
        provider.cancelStateTransfer(this.siteName);
        provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
    }
}

