/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1091)
public class InDoubtTxInfo {
    @ProtoField(value=1)
    final XidImpl xid;
    @ProtoField(value=2)
    final long internalId;
    @ProtoField(value=3)
    int status;
    private final transient Set<Address> owners = new HashSet<Address>();
    private transient boolean isLocal;

    @ProtoFactory
    public InDoubtTxInfo(XidImpl xid, long internalId, int status) {
        this.xid = xid;
        this.internalId = internalId;
        this.status = status;
    }

    public InDoubtTxInfo(XidImpl xid, long internalId) {
        this(xid, internalId, -1);
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Set<Address> getOwners() {
        return this.owners;
    }

    public void addOwner(Address owner) {
        this.owners.add(owner);
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDoubtTxInfo that = (InDoubtTxInfo)o;
        return this.internalId == that.internalId && this.status == that.status && this.isLocal == that.isLocal && Objects.equals(this.xid, that.xid) && Objects.equals(this.owners, that.owners);
    }

    public int hashCode() {
        return Objects.hash(this.xid, this.internalId, this.status, this.owners, this.isLocal);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{xid=" + String.valueOf(this.xid) + ", internalId=" + this.internalId + ", status=" + this.status + ", owners=" + String.valueOf(this.owners) + ", isLocal=" + this.isLocal + "}";
    }
}

