/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1087)
public class GlobalTransaction
implements Cloneable {
    private static final AtomicLong sid = new AtomicLong(0L);
    private long id;
    private Address addr;
    private int hash_code = -1;
    private boolean remote = false;
    private volatile XidImpl xid = null;
    private volatile long internalId = -1L;

    public GlobalTransaction(Address addr, boolean remote) {
        this.id = sid.incrementAndGet();
        this.addr = addr;
        this.remote = remote;
    }

    @ProtoFactory
    GlobalTransaction(long id, WrappedMessage wrappedAddress, XidImpl xid, long internalId) {
        this.id = id;
        this.addr = (Address)WrappedMessages.unwrap(wrappedAddress);
        this.xid = xid;
        this.internalId = internalId;
    }

    public Address getAddress() {
        return this.addr;
    }

    @ProtoField(number=1, name="address")
    WrappedMessage getWrappedAddress() {
        return WrappedMessages.orElseNull(this.addr);
    }

    @ProtoField(value=2)
    public long getId() {
        return this.id;
    }

    @ProtoField(value=3)
    public XidImpl getXid() {
        return this.xid;
    }

    @ProtoField(value=4)
    public long getInternalId() {
        return this.internalId;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        return this.id == otherGtx.id && Objects.equals(this.addr, otherGtx.addr);
    }

    public final String globalId() {
        return String.valueOf(this.getAddress()) + ":" + this.getId();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public void setXid(Xid xid) {
        this.xid = XidImpl.copy((Xid)xid);
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public String toString() {
        return "GlobalTransaction{id=" + this.id + ", addr=" + Objects.toString(this.addr, "local") + ", remote=" + this.remote + ", xid=" + String.valueOf(this.xid) + ", internalId=" + this.internalId + "}";
    }
}

