/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.UUID;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1147)
public class PersistentUUID
implements Address {
    @ProtoField(value=1)
    final UUID uuid;
    final int hashCode;

    @ProtoFactory
    PersistentUUID(UUID uuid) {
        this.uuid = uuid;
        this.hashCode = uuid.hashCode();
    }

    public PersistentUUID(long msb, long lsb) {
        this(new UUID(msb, lsb));
    }

    public static PersistentUUID randomUUID() {
        return new PersistentUUID(Util.threadLocalRandomUUID());
    }

    public static PersistentUUID fromString(String name) {
        return new PersistentUUID(UUID.fromString(name));
    }

    public long getMostSignificantBits() {
        return this.uuid.getMostSignificantBits();
    }

    public long getLeastSignificantBits() {
        return this.uuid.getLeastSignificantBits();
    }

    @Override
    public int compareTo(Address o) {
        PersistentUUID other = (PersistentUUID)o;
        return this.uuid.compareTo(other.uuid);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.uuid.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentUUID other = (PersistentUUID)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

