/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.util.Arrays;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.Util;

@ProtoTypeId(value=15)
public class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    private static final byte[] SITE_KEY = Util.stringToBytes((String)"site-id");
    private static final byte[] RACK_KEY = Util.stringToBytes((String)"rack-id");
    private static final byte[] MACHINE_KEY = Util.stringToBytes((String)"machine-id");

    public static ExtendedUUID randomUUID(String name, String siteId, String rackId, String machineId) {
        ExtendedUUID uuid = ExtendedUUID.randomUUID((String)name);
        if (name != null) {
            NameCache.add((Address)uuid, (String)name);
        }
        JGroupsTopologyAwareAddress.addId(uuid, SITE_KEY, siteId);
        JGroupsTopologyAwareAddress.addId(uuid, RACK_KEY, rackId);
        JGroupsTopologyAwareAddress.addId(uuid, MACHINE_KEY, machineId);
        return uuid;
    }

    private static void addId(ExtendedUUID uuid, byte[] key, String stringValue) {
        if (stringValue != null) {
            uuid.put(key, Util.stringToBytes((String)stringValue));
        }
    }

    @ProtoFactory
    static JGroupsTopologyAwareAddress protoFactory(byte[] bytes) throws IOException {
        return (JGroupsTopologyAwareAddress)JGroupsAddress.protoFactory(bytes);
    }

    public JGroupsTopologyAwareAddress(ExtendedUUID address) {
        super((Address)address);
    }

    @Override
    public String getSiteId() {
        return this.getString(SITE_KEY);
    }

    @Override
    public String getRackId() {
        return this.getString(RACK_KEY);
    }

    @Override
    public String getMachineId() {
        return this.getString(MACHINE_KEY);
    }

    public boolean matches(String siteId, String rackId, String machineId) {
        return this.checkComponent(SITE_KEY, siteId) && this.checkComponent(RACK_KEY, rackId) && this.checkComponent(MACHINE_KEY, machineId);
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID) && this.checkComponent(RACK_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId()) && this.checkComponent(RACK_KEY, addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (addr instanceof JGroupsTopologyAwareAddress) {
            ExtendedUUID otherUUID = ((JGroupsTopologyAwareAddress)addr).topologyAddress();
            return this.checkComponent(SITE_KEY, otherUUID) && this.checkComponent(RACK_KEY, otherUUID) && this.checkComponent(MACHINE_KEY, otherUUID);
        }
        return this.checkComponent(SITE_KEY, addr.getSiteId()) && this.checkComponent(RACK_KEY, addr.getRackId()) && this.checkComponent(MACHINE_KEY, addr.getMachineId());
    }

    private boolean checkComponent(byte[] key, ExtendedUUID uuid) {
        return this.checkComponent(key, uuid.get(key));
    }

    private boolean checkComponent(byte[] key, String stringValue) {
        return this.checkComponent(key, Util.stringToBytes((String)stringValue));
    }

    private boolean checkComponent(byte[] key, byte[] expectedValue) {
        return Arrays.equals(this.getBytes(key), expectedValue);
    }

    private String getString(byte[] key) {
        return Util.bytesToString((byte[])this.getBytes(key));
    }

    private byte[] getBytes(byte[] key) {
        return this.topologyAddress().get(key);
    }

    private ExtendedUUID topologyAddress() {
        return (ExtendedUUID)this.address;
    }
}

