/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;

public interface RpcManager {
    public <T> CompletionStage<T> invokeCommand(Address var1, CacheRpcCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommand(Collection<Address> var1, CacheRpcCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommandOnAll(CacheRpcCommand var1, ResponseCollector<T> var2, RpcOptions var3);

    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> var1, CacheRpcCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommands(Collection<Address> var1, Function<Address, CacheRpcCommand> var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> T blocking(CompletionStage<T> var1);

    @Deprecated(forRemoval=true, since="11.0")
    default public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, CacheRpcCommand command, RpcOptions options) {
        Collection<Address> targets = recipients != null ? recipients : this.getTransport().getMembers();
        MapResponseCollector collector = MapResponseCollector.ignoreLeavers(false, targets.size());
        return this.invokeCommand(recipients, command, collector, options).toCompletableFuture();
    }

    public void sendTo(Address var1, CacheRpcCommand var2, DeliverOrder var3);

    public void sendToMany(Collection<Address> var1, CacheRpcCommand var2, DeliverOrder var3);

    public void sendToAll(CacheRpcCommand var1, DeliverOrder var2);

    public <O> XSiteResponse<O> invokeXSite(XSiteBackup var1, XSiteCacheRequest<O> var2);

    public Transport getTransport();

    public List<Address> getMembers();

    public Address getAddress();

    public int getTopologyId();

    public RpcOptions getSyncRpcOptions();

    default public RpcOptions getTotalSyncRpcOptions() {
        throw new UnsupportedOperationException();
    }
}

