/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.impl.PublisherHandler;

@ProtoTypeId(value=1149)
public class PublisherResponse {
    final Object[] results;
    final IntSet completedSegments;
    final IntSet lostSegments;
    final boolean complete;
    final List<PublisherHandler.SegmentResult> segmentResults;
    final transient int size;

    public PublisherResponse(Object[] results, IntSet completedSegments, IntSet lostSegments, int size, boolean complete, List<PublisherHandler.SegmentResult> segmentResults) {
        this.results = results;
        this.completedSegments = completedSegments;
        this.lostSegments = lostSegments;
        this.size = size;
        this.complete = complete;
        this.segmentResults = segmentResults;
    }

    @ProtoFactory
    PublisherResponse(MarshallableArray<Object> wrappedResults, WrappedMessage completedSegmentsWrapped, WrappedMessage lostSegmentsWrapped, boolean complete, List<PublisherHandler.SegmentResult> segmentResults) {
        this.results = MarshallableArray.unwrap(wrappedResults);
        this.completedSegments = (IntSet)WrappedMessages.unwrap(completedSegmentsWrapped);
        this.lostSegments = (IntSet)WrappedMessages.unwrap(lostSegmentsWrapped);
        this.complete = complete;
        this.size = this.results.length;
        this.segmentResults = segmentResults;
    }

    public static PublisherResponse emptyResponse(IntSet completedSegments, IntSet lostSegments) {
        return new PublisherResponse(Util.EMPTY_OBJECT_ARRAY, completedSegments, lostSegments, 0, true, Collections.emptyList());
    }

    public Object[] getResults() {
        return this.results;
    }

    @ProtoField(number=1, name="results")
    MarshallableArray<Object> wrappedResults() {
        return MarshallableArray.create(this.results);
    }

    public IntSet getCompletedSegments() {
        return this.completedSegments;
    }

    @ProtoField(number=2, name="completedSegments")
    WrappedMessage getCompletedSegmentsWrapped() {
        return WrappedMessages.orElseNull(this.completedSegments);
    }

    public IntSet getLostSegments() {
        return this.lostSegments;
    }

    @ProtoField(number=3, name="lostSegments")
    WrappedMessage getLostSegmentsWrapped() {
        return WrappedMessages.orElseNull(this.lostSegments);
    }

    public int getSize() {
        return this.size;
    }

    @ProtoField(value=4)
    public boolean isComplete() {
        return this.complete;
    }

    @ProtoField(value=5)
    public List<PublisherHandler.SegmentResult> getSegmentResults() {
        return this.segmentResults;
    }

    public void keysForNonCompletedSegments(ObjIntConsumer consumer) {
        int segmentResultSize = this.segmentResults.size();
        if (segmentResultSize == 0) {
            return;
        }
        PublisherHandler.SegmentResult segmentResult = this.segmentResults.get(segmentResultSize - 1);
        int segment = segmentResult.getSegment();
        for (int i = segmentResult.getEntryCount(); i > 0; --i) {
            consumer.accept(this.results[this.size - i], segment);
        }
    }

    public String toString() {
        return "PublisherResponse{size=" + this.size + ", completedSegments=" + String.valueOf(this.completedSegments) + ", lostSegments=" + String.valueOf(this.lostSegments) + ", complete=" + this.complete + ", segmentResults=" + String.valueOf(this.segmentResults) + "}";
    }
}

