/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.marshall.protostream.impl.MarshallableSet;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.util.ByteString;
import org.reactivestreams.Publisher;

@ProtoTypeId(value=1092)
public class InitialPublisherCommand<K, I, R>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    final String requestId;
    final DeliveryGuarantee deliveryGuarantee;
    final int batchSize;
    final IntSet segments;
    final Set<K> keys;
    final Set<K> excludedKeys;
    final long explicitFlags;
    final boolean entryStream;
    final boolean trackKeys;
    final Function<? super Publisher<I>, ? extends Publisher<R>> transformer;
    private int topologyId = -1;

    public InitialPublisherCommand(ByteString cacheName, String requestId, DeliveryGuarantee deliveryGuarantee, int batchSize, IntSet segments, Set<K> keys, Set<K> excludedKeys, long explicitFlags, boolean entryStream, boolean trackKeys, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
        super(cacheName);
        this.requestId = requestId;
        this.deliveryGuarantee = deliveryGuarantee;
        this.batchSize = batchSize;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.explicitFlags = explicitFlags;
        this.entryStream = entryStream;
        this.trackKeys = trackKeys;
        this.transformer = transformer;
    }

    @ProtoFactory
    InitialPublisherCommand(ByteString cacheName, String requestId, DeliveryGuarantee deliveryGuarantee, int batchSize, WrappedMessage wrappedSegments, MarshallableSet<K> wrappedKeys, MarshallableSet<K> wrappedExcludedKeys, long explicitFlags, boolean entryStream, boolean trackKeys, int topologyId, MarshallableObject<Function<? super Publisher<I>, ? extends Publisher<R>>> wrappedTransformer) {
        super(cacheName);
        this.requestId = requestId;
        this.deliveryGuarantee = deliveryGuarantee;
        this.batchSize = batchSize;
        this.segments = (IntSet)WrappedMessages.unwrap(wrappedSegments);
        this.keys = MarshallableSet.unwrap(wrappedKeys);
        this.excludedKeys = MarshallableSet.unwrap(wrappedExcludedKeys);
        this.explicitFlags = explicitFlags;
        this.entryStream = entryStream;
        this.trackKeys = trackKeys;
        this.transformer = MarshallableObject.unwrap(wrappedTransformer);
        this.topologyId = topologyId;
    }

    @ProtoField(value=2)
    public String getRequestId() {
        return this.requestId;
    }

    @ProtoField(value=3)
    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    @ProtoField(value=4)
    public int getBatchSize() {
        return this.batchSize;
    }

    public IntSet getSegments() {
        return this.segments;
    }

    @ProtoField(value=5)
    WrappedMessage getWrappedSegments() {
        return WrappedMessages.orElseNull(this.segments);
    }

    public Set<K> getKeys() {
        return this.keys;
    }

    @ProtoField(number=6, name="keys")
    MarshallableSet<K> getWrappedKeys() {
        return MarshallableSet.create(this.keys);
    }

    public Set<K> getExcludedKeys() {
        return this.excludedKeys;
    }

    @ProtoField(number=7, name="excludedKeys")
    MarshallableSet<K> getWrappedExcludedKeys() {
        return MarshallableSet.create(this.excludedKeys);
    }

    @ProtoField(value=8)
    public long getExplicitFlags() {
        return this.explicitFlags;
    }

    @ProtoField(value=9)
    public boolean isEntryStream() {
        return this.entryStream;
    }

    @ProtoField(value=10)
    public boolean isTrackKeys() {
        return this.trackKeys;
    }

    public Function<? super Publisher<I>, ? extends Publisher<R>> getTransformer() {
        return this.transformer;
    }

    @ProtoField(number=11, name="transformer")
    MarshallableObject<Function<? super Publisher<I>, ? extends Publisher<R>>> getWrappedTransformer() {
        return MarshallableObject.create(this.transformer);
    }

    @Override
    @ProtoField(value=12)
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (this.transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.transformer)).inject(componentRegistry);
        }
        PublisherHandler publisherHandler = componentRegistry.getPublisherHandler().running();
        return publisherHandler.register(this);
    }
}

