/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1058)
public class ClusterListenerRemoveCallable
implements Function<EmbeddedCacheManager, Void> {
    private static final Log log = LogFactory.getLog(ClusterListenerRemoveCallable.class);
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final UUID identifier;

    @ProtoFactory
    public ClusterListenerRemoveCallable(String cacheName, UUID identifier) {
        this.cacheName = cacheName;
        this.identifier = identifier;
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        BasicCache cache = embeddedCacheManager.getCache(this.cacheName);
        CacheNotifierImpl notifier = (CacheNotifierImpl)ComponentRegistry.componentOf(cache, CacheNotifier.class);
        Set<Object> listeners = notifier.getListeners();
        for (Object listener : listeners) {
            RemoteClusterListener clusterListener;
            if (!(listener instanceof RemoteClusterListener) || !this.identifier.equals((clusterListener = (RemoteClusterListener)listener).getId())) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Removing local cluster listener due to parent cluster listener was removed : %s", this.identifier);
            }
            clusterListener.removeListener();
        }
        return null;
    }
}

