/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding;

import java.util.Objects;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1068)
@Scope(value=Scopes.NONE)
public final class DataConversion {
    @Deprecated(forRemoval=true, since="11.0")
    public static final DataConversion DEFAULT_KEY = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)ByteArrayWrapper.INSTANCE, true);
    @Deprecated(forRemoval=true, since="11.0")
    public static final DataConversion DEFAULT_VALUE = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)ByteArrayWrapper.INSTANCE, false);
    @Deprecated(forRemoval=true, since="11.0")
    public static final DataConversion IDENTITY_KEY = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)IdentityWrapper.INSTANCE, true);
    @Deprecated(forRemoval=true, since="11.0")
    public static final DataConversion IDENTITY_VALUE = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)IdentityWrapper.INSTANCE, false);
    private final transient Class<? extends Encoder> encoderClass;
    private transient Class<? extends Wrapper> wrapperClass;
    private final short encoderId;
    private final byte wrapperId;
    private final MediaType requestMediaType;
    private final boolean isKey;
    private transient MediaType storageMediaType;
    private transient Encoder encoder;
    private transient Wrapper customWrapper;
    private transient Transcoder transcoder;
    private transient EncoderRegistry encoderRegistry;
    private transient StorageConfigurationManager storageConfigurationManager;

    private DataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass, MediaType requestMediaType, boolean isKey) {
        this.encoderClass = encoderClass;
        this.wrapperClass = wrapperClass;
        this.requestMediaType = requestMediaType;
        this.isKey = isKey;
        this.encoderId = 0;
        this.wrapperId = 0;
    }

    private DataConversion(Short encoderId, Byte wrapperId, MediaType requestMediaType, boolean isKey) {
        this.encoderId = encoderId;
        this.wrapperId = wrapperId;
        this.requestMediaType = requestMediaType;
        this.isKey = isKey;
        this.encoderClass = null;
        this.wrapperClass = null;
    }

    private DataConversion(Encoder encoder, Wrapper wrapper, boolean isKey) {
        this.encoder = encoder;
        this.customWrapper = wrapper;
        this.encoderClass = encoder.getClass();
        this.wrapperClass = wrapper.getClass();
        this.isKey = isKey;
        this.storageMediaType = MediaType.APPLICATION_OBJECT;
        this.requestMediaType = MediaType.APPLICATION_OBJECT;
        this.encoderId = 0;
        this.wrapperId = 0;
    }

    @ProtoFactory
    static DataConversion protoFactory(boolean isKey, short encoderId, byte wrapperId, MediaType mediaType) {
        return new DataConversion(encoderId, wrapperId, mediaType, isKey);
    }

    @ProtoField(value=1)
    boolean getIsKey() {
        return this.isKey;
    }

    @ProtoField(value=2)
    short getEncoderId() {
        return this.encoder.id();
    }

    @ProtoField(value=3)
    byte getWrapperId() {
        return this.customWrapper != null ? this.customWrapper.id() : (byte)0;
    }

    @ProtoField(value=4)
    MediaType getMediaType() {
        return this.requestMediaType;
    }

    public DataConversion withRequestMediaType(MediaType requestMediaType) {
        if (Objects.equals(this.requestMediaType, requestMediaType)) {
            return this;
        }
        return new DataConversion(this.encoderClass, this.wrapperClass, requestMediaType, this.isKey);
    }

    @Deprecated(forRemoval=true, since="12.1")
    public DataConversion withEncoding(Class<? extends Encoder> encoderClass) {
        if (this.encoderClass == encoderClass) {
            return this;
        }
        return new DataConversion(encoderClass, this.wrapperClass, this.requestMediaType, this.isKey);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public DataConversion withWrapping(Class<? extends Wrapper> wrapperClass) {
        if (this.wrapperClass == wrapperClass) {
            return this;
        }
        return new DataConversion(this.encoderClass, wrapperClass, this.requestMediaType, this.isKey);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public void overrideWrapper(Class<? extends Wrapper> newWrapper, ComponentRegistry cr) {
        this.customWrapper = null;
        this.wrapperClass = newWrapper;
        cr.wireDependencies(this);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public boolean isConversionSupported(MediaType mediaType) {
        return this.storageMediaType == null || this.encoderRegistry.isConversionSupported(this.storageMediaType, mediaType);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public Object convert(Object o, MediaType from, MediaType to) {
        if (o == null) {
            return null;
        }
        if (this.encoderRegistry == null) {
            return o;
        }
        Transcoder transcoder = this.encoderRegistry.getTranscoder(from, to);
        return transcoder.transcode(o, from, to);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public Object convertToRequestFormat(Object o, MediaType contentType) {
        if (o == null) {
            return null;
        }
        if (this.requestMediaType == null) {
            return this.fromStorage(o);
        }
        Transcoder transcoder = this.encoderRegistry.getTranscoder(contentType, this.requestMediaType);
        return transcoder.transcode(o, contentType, this.requestMediaType);
    }

    @Inject
    void injectDependencies(StorageConfigurationManager storageConfigurationManager, EncoderRegistry encoderRegistry) {
        if (this.encoder != null && this.customWrapper != null) {
            return;
        }
        this.storageMediaType = storageConfigurationManager.getStorageMediaType(this.isKey);
        this.encoderRegistry = encoderRegistry;
        this.storageConfigurationManager = storageConfigurationManager;
        this.customWrapper = encoderRegistry.getWrapper(this.wrapperClass, this.wrapperId);
        this.lookupEncoder();
        this.lookupTranscoder();
    }

    private void lookupEncoder() {
        boolean isEncodingEmpty = this.encoderClass == null && this.encoderId == 0;
        Class actualEncoderClass = isEncodingEmpty ? IdentityEncoder.class : this.encoderClass;
        this.encoder = this.encoderRegistry.getEncoder(actualEncoderClass, this.encoderId);
    }

    private void lookupTranscoder() {
        boolean needsTranscoding;
        boolean bl = needsTranscoding = this.storageMediaType != null && this.requestMediaType != null && !this.requestMediaType.matchesAll() && !this.requestMediaType.equals((Object)this.storageMediaType);
        if (needsTranscoding) {
            Transcoder directTranscoder = null;
            if (this.encoder.getStorageFormat() != null) {
                try {
                    directTranscoder = this.encoderRegistry.getTranscoder(this.requestMediaType, this.encoder.getStorageFormat());
                }
                catch (EncodingException encodingException) {
                    // empty catch block
                }
            }
            if (directTranscoder != null) {
                if (this.encoder.getStorageFormat().equals((Object)MediaType.APPLICATION_OBJECT)) {
                    this.encoder = IdentityEncoder.INSTANCE;
                }
                this.transcoder = directTranscoder;
            } else {
                this.transcoder = this.encoderRegistry.getTranscoder(this.requestMediaType, this.storageMediaType);
            }
        }
    }

    public Object fromStorage(Object stored) {
        if (stored == null) {
            return null;
        }
        Object fromStorage = this.encoder.fromStorage(this.getWrapper().unwrap(stored));
        return this.transcoder == null ? fromStorage : this.transcoder.transcode(fromStorage, this.storageMediaType, this.requestMediaType);
    }

    public Object toStorage(Object toStore) {
        if (toStore == null) {
            return null;
        }
        toStore = this.transcoder == null ? toStore : this.transcoder.transcode(toStore, this.requestMediaType, this.storageMediaType);
        return this.getWrapper().wrap(this.encoder.toStorage(toStore));
    }

    public Object extractIndexable(Object stored, boolean javaEmbeddedEntities) {
        if (stored == null) {
            return null;
        }
        Wrapper wrapper = this.getWrapper();
        if (this.isKey) {
            return wrapper.unwrap(stored);
        }
        if (wrapper.isFilterable() && !javaEmbeddedEntities) {
            return stored.getClass() == this.wrapperClass ? stored : wrapper.wrap(stored);
        }
        Object unencoded = this.encoder.fromStorage(wrapper.unwrap(stored));
        return this.transcoder == null ? unencoded : this.transcoder.transcode(unencoded, this.storageMediaType, this.requestMediaType);
    }

    public MediaType getRequestMediaType() {
        return this.requestMediaType;
    }

    public MediaType getStorageMediaType() {
        return this.storageMediaType;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    @Deprecated(forRemoval=true, since="11.0")
    public Wrapper getWrapper() {
        if (this.customWrapper != null) {
            return this.customWrapper;
        }
        return this.storageConfigurationManager.getWrapper(this.isKey);
    }

    public Class<? extends Encoder> getEncoderClass() {
        return this.encoderClass;
    }

    @Deprecated(forRemoval=true, since="11.0")
    public Class<? extends Wrapper> getWrapperClass() {
        return this.wrapperClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConversion that = (DataConversion)o;
        return this.isKey == that.isKey && Objects.equals(this.encoder, that.encoder) && Objects.equals(this.customWrapper, that.customWrapper) && Objects.equals(this.transcoder, that.transcoder) && Objects.equals(this.requestMediaType, that.requestMediaType);
    }

    public String toString() {
        return "DataConversion{encoderClass=" + String.valueOf(this.encoderClass) + ", wrapperClass=" + String.valueOf(this.wrapperClass) + ", requestMediaType=" + String.valueOf(this.requestMediaType) + ", storageMediaType=" + String.valueOf(this.storageMediaType) + ", encoderId=" + this.encoderId + ", wrapperId=" + this.wrapperId + ", encoder=" + String.valueOf(this.encoder) + ", wrapper=" + String.valueOf(this.customWrapper) + ", isKey=" + this.isKey + ", transcoder=" + String.valueOf(this.transcoder) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.encoderClass, this.wrapperClass, this.requestMediaType, this.isKey);
    }

    public static DataConversion newKeyDataConversion() {
        return new DataConversion(IdentityEncoder.class, null, MediaType.APPLICATION_OBJECT, true);
    }

    public static DataConversion newValueDataConversion() {
        return new DataConversion(IdentityEncoder.class, null, MediaType.APPLICATION_OBJECT, false);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public static DataConversion newKeyDataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass) {
        return new DataConversion(encoderClass, wrapperClass, MediaType.APPLICATION_OBJECT, true);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public static DataConversion newValueDataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass) {
        return new DataConversion(encoderClass, wrapperClass, MediaType.APPLICATION_OBJECT, false);
    }
}

