/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.concurrent.TimeUnit;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1216)
public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    protected long maxIdle;
    protected long lastUsed;

    public TransientCacheEntry(Object key, Object value, long maxIdle, long lastUsed) {
        this(key, value, null, maxIdle, lastUsed);
    }

    protected TransientCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, long maxIdle, long lastUsed) {
        super(key, value, internalMetadata);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    TransientCacheEntry(MarshallableObject<?> wrappedKey, MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, long maxIdle, long lastUsed) {
        super(wrappedKey, wrappedValue, internalMetadata);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    @ProtoField(value=4)
    public final long getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    @ProtoField(value=5)
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.maxIdle, this.lastUsed, now);
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new TransientCacheValue(this.value, this.internalMetadata, this.maxIdle, this.lastUsed);
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().maxIdle(this.maxIdle, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public TransientCacheEntry clone() {
        return (TransientCacheEntry)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", lastUsed=").append(this.lastUsed);
        builder.append(", maxIdle=").append(this.maxIdle);
    }
}

