/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.List;
import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.AllowListConfiguration;
import org.infinispan.configuration.global.WhiteListConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;

public class SerializationConfiguration {
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((Enum)Attribute.MARSHALLER, null, Marshaller.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<List<SerializationContextInitializer>> SERIALIZATION_CONTEXT_INITIALIZERS = AttributeDefinition.builder((String)"contextInitializers", null, List.class).immutable().build();
    public static final AttributeDefinition<Configuration.SchemaValidation> SCHEMA_COMPATIBILITY = AttributeDefinition.builder((Enum)Attribute.SCHEMA_COMPATIBILITY, (Object)Configuration.SchemaValidation.STRICT, Configuration.SchemaValidation.class).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Marshaller> marshaller;
    private final org.infinispan.commons.configuration.attributes.Attribute<List<SerializationContextInitializer>> contextInitializers;
    private final AttributeSet attributes;
    private final AllowListConfiguration allowListConfig;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SerializationConfiguration.class, new AttributeDefinition[]{MARSHALLER, SERIALIZATION_CONTEXT_INITIALIZERS, SCHEMA_COMPATIBILITY});
    }

    SerializationConfiguration(AttributeSet attributes, AllowListConfiguration allowListConfig) {
        this.attributes = attributes.checkProtection();
        this.marshaller = attributes.attribute(MARSHALLER);
        this.contextInitializers = attributes.attribute(SERIALIZATION_CONTEXT_INITIALIZERS);
        this.allowListConfig = allowListConfig;
    }

    public Marshaller marshaller() {
        return (Marshaller)this.marshaller.get();
    }

    public List<SerializationContextInitializer> contextInitializers() {
        return (List)this.contextInitializers.get();
    }

    public Configuration.SchemaValidation schemaCompatibilityValidation() {
        return (Configuration.SchemaValidation)this.attributes.attribute(SCHEMA_COMPATIBILITY).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AllowListConfiguration allowList() {
        return this.allowListConfig;
    }

    @Deprecated(forRemoval=true, since="11.0")
    public WhiteListConfiguration whiteList() {
        return new WhiteListConfiguration(this.allowListConfig);
    }

    public String toString() {
        return "SerializationConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfiguration that = (SerializationConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

