/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Proto
@ProtoTypeId(value=1044)
public enum CacheMode {
    LOCAL,
    REPL_SYNC,
    REPL_ASYNC,
    INVALIDATION_SYNC,
    INVALIDATION_ASYNC,
    DIST_SYNC,
    DIST_ASYNC;

    private static final CacheMode[] cachedValues;

    public static CacheMode valueOf(int order) {
        return cachedValues[order];
    }

    public static CacheMode of(CacheType cacheType, boolean sync) {
        switch (cacheType) {
            case REPLICATION: {
                return sync ? REPL_SYNC : REPL_ASYNC;
            }
            case DISTRIBUTION: {
                return sync ? DIST_SYNC : DIST_ASYNC;
            }
            case INVALIDATION: {
                return sync ? INVALIDATION_SYNC : INVALIDATION_ASYNC;
            }
        }
        return LOCAL;
    }

    public boolean isInvalidation() {
        return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
    }

    public boolean isSynchronous() {
        return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
    }

    public boolean isClustered() {
        return this != LOCAL;
    }

    public boolean isDistributed() {
        return this == DIST_SYNC || this == DIST_ASYNC;
    }

    public boolean isReplicated() {
        return this == REPL_SYNC || this == REPL_ASYNC;
    }

    public boolean needsStateTransfer() {
        return this.isReplicated() || this.isDistributed();
    }

    public CacheMode toSync() {
        switch (this.ordinal()) {
            case 2: {
                return REPL_SYNC;
            }
            case 4: {
                return INVALIDATION_SYNC;
            }
            case 6: {
                return DIST_SYNC;
            }
        }
        return this;
    }

    public CacheMode toSync(boolean sync) {
        return sync ? this.toSync() : this.toAsync();
    }

    public CacheMode toAsync() {
        switch (this.ordinal()) {
            case 1: {
                return REPL_ASYNC;
            }
            case 3: {
                return INVALIDATION_ASYNC;
            }
            case 5: {
                return DIST_ASYNC;
            }
        }
        return this;
    }

    public String friendlyCacheModeString() {
        switch (this.ordinal()) {
            case 1: 
            case 2: {
                return "REPLICATED";
            }
            case 3: 
            case 4: {
                return "INVALIDATED";
            }
            case 5: 
            case 6: {
                return "DISTRIBUTED";
            }
            case 0: {
                return "LOCAL";
            }
        }
        throw new IllegalArgumentException("Unknown cache mode " + String.valueOf((Object)this));
    }

    public String toCacheType() {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return Element.DISTRIBUTED_CACHE.getLocalName();
            }
            case 1: 
            case 2: {
                return Element.REPLICATED_CACHE.getLocalName();
            }
            case 3: 
            case 4: {
                return Element.INVALIDATION_CACHE.getLocalName();
            }
        }
        return Element.LOCAL_CACHE.getLocalName();
    }

    public Element toElement(boolean template) {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return template ? Element.DISTRIBUTED_CACHE_CONFIGURATION : Element.DISTRIBUTED_CACHE;
            }
            case 1: 
            case 2: {
                return template ? Element.REPLICATED_CACHE_CONFIGURATION : Element.REPLICATED_CACHE;
            }
            case 3: 
            case 4: {
                return template ? Element.INVALIDATION_CACHE_CONFIGURATION : Element.INVALIDATION_CACHE;
            }
        }
        return template ? Element.LOCAL_CACHE_CONFIGURATION : Element.LOCAL_CACHE;
    }

    public CacheType cacheType() {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return CacheType.DISTRIBUTION;
            }
            case 1: 
            case 2: {
                return CacheType.REPLICATION;
            }
            case 3: 
            case 4: {
                return CacheType.INVALIDATION;
            }
        }
        return CacheType.LOCAL;
    }

    static {
        cachedValues = CacheMode.values();
    }
}

