/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1172)
public class RollbackCommand
extends AbstractTransactionBoundaryCommand {
    public RollbackCommand(ByteString cacheName, GlobalTransaction globalTransaction) {
        super(-1, cacheName, globalTransaction);
    }

    @ProtoFactory
    public RollbackCommand(int topologyId, ByteString cacheName, GlobalTransaction globalTransaction) {
        super(topologyId, cacheName, globalTransaction);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        TransactionTable txTable = registry.getTransactionTableRef().running();
        txTable.markTransactionCompleted(this.globalTx, false);
        return super.invokeAsync(registry);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRollbackCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public void visitRemoteTransaction(RemoteTransaction tx) {
        tx.markForRollback(true);
    }

    @Override
    public String toString() {
        return "RollbackCommand {" + super.toString();
    }
}

