/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.topology.RebalancingStatus;

@ProtoTypeId(value=1164)
public class RebalanceStatusRequestCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;

    public RebalanceStatusRequestCommand() {
        this((String)null);
    }

    @ProtoFactory
    public RebalanceStatusRequestCommand(String cacheName) {
        this.cacheName = cacheName;
    }

    public CompletionStage<RebalancingStatus> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        RebalancingStatus status = this.cacheName == null ? (gcr.getClusterTopologyManager().isRebalancingEnabled() ? RebalancingStatus.PENDING : RebalancingStatus.SUSPENDED) : gcr.getClusterTopologyManager().getRebalancingStatus(this.cacheName);
        return CompletableFuture.completedFuture(status);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return "RebalanceStatusCommand{cacheName='" + this.cacheName + "'}";
    }
}

