/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableThrowable;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1160)
public class RebalancePhaseConfirmCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final int topologyId;
    final Throwable throwable;

    public RebalancePhaseConfirmCommand(String cacheName, Address origin, Throwable throwable, int topologyId) {
        super(origin);
        this.cacheName = cacheName;
        this.throwable = throwable;
        this.topologyId = topologyId;
    }

    @ProtoFactory
    RebalancePhaseConfirmCommand(String cacheName, int topologyId, MarshallableThrowable throwable) {
        this(cacheName, null, MarshallableThrowable.unwrap(throwable), topologyId);
    }

    @ProtoField(value=3)
    MarshallableThrowable getThrowable() {
        return MarshallableThrowable.create(this.throwable);
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleRebalancePhaseConfirm(this.cacheName, this.origin, this.topologyId, this.throwable);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return "RebalancePhaseConfirmCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", throwable=" + String.valueOf(this.throwable) + ", topologyId=" + this.topologyId + "}";
    }
}

