/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1188)
public class StateTransferGetTransactionsCommand
extends AbstractStateTransferCommand {
    @ProtoFactory
    StateTransferGetTransactionsCommand(ByteString cacheName, int topologyId, WrappedMessage wrappedSegments) {
        this(cacheName, topologyId, (IntSet)WrappedMessages.unwrap(wrappedSegments));
    }

    public StateTransferGetTransactionsCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super(cacheName, topologyId, segments);
    }

    public CompletionStage<List<TransactionInfo>> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        return stateProvider.getTransactionsForSegments(this.origin, this.topologyId, this.segments);
    }

    @Override
    public String toString() {
        return "StateTransferGetTransactionsCommand{topologyId=" + this.topologyId + ", segments=" + String.valueOf(this.segments) + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

