/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.statetransfer.StateTransferCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1189)
public class StateTransferGetListenersCommand
extends BaseRpcCommand
implements StateTransferCommand,
TopologyAffectedCommand {
    @ProtoField(value=2)
    int topologyId;

    @ProtoFactory
    public StateTransferGetListenersCommand(ByteString cacheName, int topologyId) {
        super(cacheName);
        this.topologyId = topologyId;
    }

    public CompletionStage<Collection<ClusterListenerReplicateCallable<Object, Object>>> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        Collection<ClusterListenerReplicateCallable<Object, Object>> listeners = stateProvider.getClusterListenersToInstall();
        return CompletableFuture.completedFuture(listeners);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "StateTransferGetListenersCommand{topologyId=" + this.topologyId + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

