/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1064)
public class CompleteTransactionCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final XidImpl xid;
    @ProtoField(value=3)
    final boolean commit;

    @ProtoFactory
    public CompleteTransactionCommand(ByteString cacheName, XidImpl xid, boolean commit) {
        super(cacheName);
        this.xid = xid;
        this.commit = commit;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        return recoveryManager.forceTransactionCompletion(this.xid, this.commit);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + String.valueOf(this.xid) + ", commit=" + this.commit + ", cacheName=" + String.valueOf(this.cacheName) + "} ";
    }
}

