/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyInfo;

@ProtoTypeId(value=1096)
public class IracCleanupKeysCommand
extends BaseIracCommand {
    private final Collection<IracManagerKeyInfo> cleanup;

    @ProtoFactory
    public IracCleanupKeysCommand(ByteString cacheName, Collection<IracManagerKeyInfo> cleanup) {
        super(cacheName);
        this.cleanup = cleanup;
    }

    @ProtoField(value=2)
    Collection<IracManagerKeyInfo> getCleanup() {
        return this.cleanup;
    }

    public CompletableFuture<Object> invokeAsync(ComponentRegistry componentRegistry) {
        IracManager manager = componentRegistry.getIracManager().running();
        this.cleanup.forEach(manager::removeState);
        return CompletableFutures.completedNull();
    }

    public String toString() {
        return "IracCleanupKeysCommand{cacheName=" + String.valueOf(this.cacheName) + ", cleanup=" + Util.toStr(this.cleanup) + "}";
    }
}

