/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Collection;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1158)
public final class ReadWriteManyCommand<K, V, R>
extends AbstractWriteManyCommand<K, V> {
    private Collection<?> keys;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;

    public ReadWriteManyCommand(ByteString cacheName, Collection<?> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cacheName, commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.keys = keys;
        this.f = f;
    }

    public ReadWriteManyCommand(ReadWriteManyCommand command) {
        super(command);
        this.keys = command.keys;
        this.f = command.f;
    }

    @ProtoFactory
    ReadWriteManyCommand(ByteString cacheName, CommandInvocationId commandInvocationId, boolean forwarded, int topologyId, Params params, long flags, DataConversion keyDataConversion, DataConversion valueDataConversion, MarshallableMap<Object, PrivateMetadata> internalMetadata, MarshallableCollection<?> keys, MarshallableObject<Function<EntryView.ReadWriteEntryView<K, V>, R>> wrappedFunction) {
        super(cacheName, commandInvocationId, forwarded, topologyId, params, flags, keyDataConversion, valueDataConversion, internalMetadata);
        this.keys = MarshallableCollection.unwrap(keys);
        this.f = MarshallableObject.unwrap(wrappedFunction);
    }

    @ProtoField(value=10)
    MarshallableCollection<?> getKeys() {
        return MarshallableCollection.create(this.keys);
    }

    @ProtoField(number=11, name="function")
    MarshallableObject<Function<EntryView.ReadWriteEntryView<K, V>, R>> getWrappedFunction() {
        return MarshallableObject.create(this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public Function<EntryView.ReadWriteEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
        this.internalMetadataMap.keySet().retainAll(keys);
    }

    public final ReadWriteManyCommand<K, V, R> withKeys(Collection<?> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyCommand(ctx, this);
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        return "ReadWriteManyCommand{keys=" + String.valueOf(this.keys) + ", f=" + String.valueOf(this.f) + ", forwarded=" + this.forwarded + ", keyDataConversion=" + String.valueOf(this.keyDataConversion) + ", valueDataConversion=" + String.valueOf(this.valueDataConversion) + "}";
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.keys;
    }

    @Override
    public Mutation toMutation(Object key) {
        return new Mutations.ReadWrite<K, V, R>(this.keyDataConversion, this.valueDataConversion, this.f);
    }
}

