/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1122)
public class LockControlCommand
extends AbstractTransactionBoundaryCommand
implements FlagAffectedCommand,
TopologyAffectedCommand,
TransactionalRemoteLockCommand {
    private static final Log log = LogFactory.getLog(LockControlCommand.class);
    private Collection<Object> keys;
    private boolean unlock = false;
    private long flags;

    public LockControlCommand(Collection<?> keys, ByteString cacheName, long flags, GlobalTransaction globalTx) {
        super(cacheName, globalTx);
        this.keys = keys;
        this.flags = flags;
        this.globalTx = globalTx;
    }

    public LockControlCommand(Object key, ByteString cacheName, long flags, GlobalTransaction globalTx) {
        this(Collections.singletonList(key), cacheName, flags, globalTx);
    }

    @ProtoFactory
    LockControlCommand(int topologyId, ByteString cacheName, GlobalTransaction globalTransaction, MarshallableCollection<Object> wrappedKeys, boolean unlock, long flagsBitSetWithoutRemote) {
        super(topologyId, cacheName, globalTransaction);
        this.keys = MarshallableCollection.unwrap(wrappedKeys);
        this.unlock = unlock;
        this.flags = flagsBitSetWithoutRemote;
    }

    @ProtoField(number=4, name="keys")
    MarshallableCollection<Object> getWrappedKeys() {
        return MarshallableCollection.create(this.keys);
    }

    @ProtoField(value=5)
    public boolean isUnlock() {
        return this.unlock;
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @ProtoField(value=6)
    long getFlagsBitSetWithoutRemote() {
        return FlagBitSets.copyWithoutRemotableFlags(this.flags);
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Collection<Object> getKeys() {
        return this.keys;
    }

    public boolean multipleKeys() {
        return this.keys.size() > 1;
    }

    public Object getSingleKey() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.iterator().next();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        this.globalTx.setRemote(true);
        RemoteTxInvocationContext ctx = this.createContext(registry);
        if (ctx == null) {
            return CompletableFutures.completedNull();
        }
        return registry.getInterceptorChain().running().invokeAsync(ctx, this);
    }

    public RemoteTxInvocationContext createContext(ComponentRegistry componentRegistry) {
        TransactionTable txTable = componentRegistry.getTransactionTableRef().running();
        RemoteTransaction transaction = txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (this.unlock) {
                log.tracef("Unlock for missing transaction %s.  Not doing anything.", this.globalTx);
                return null;
            }
            transaction = txTable.getOrCreateRemoteTransaction(this.globalTx, Collections.emptyList());
        }
        return componentRegistry.getInvocationContextFactory().running().createRemoteTxInvocationContext(transaction, this.getOrigin());
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        return this.unlock == that.unlock && this.flags == that.flags && Objects.equals(this.keys, that.keys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keys, this.unlock, this.flags);
    }

    @Override
    public String toString() {
        return "LockControlCommand{cache=" + String.valueOf(this.cacheName) + ", keys=" + String.valueOf(this.keys) + ", flags=" + EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class) + ", unlock=" + this.unlock + ", gtx=" + String.valueOf(this.globalTx) + "}";
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.unlock ? Collections.emptyList() : Collections.unmodifiableCollection(this.keys);
    }

    @Override
    public Object getKeyLockOwner() {
        return this.globalTx;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }
}

