/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;

@ProtoTypeId(value=25)
public final class CommandInvocationId {
    public static final CommandInvocationId DUMMY_INVOCATION_ID = new CommandInvocationId(null, 0L);
    private static final AtomicLong nextId = new AtomicLong(0L);
    private final Address address;
    private final long id;

    private CommandInvocationId(Address address, long id) {
        this.address = address;
        this.id = id;
    }

    @ProtoFactory
    CommandInvocationId(JGroupsAddress address, long id) {
        this((Address)address, id);
    }

    @ProtoField(value=1)
    public long getId() {
        return this.id;
    }

    @ProtoField(number=2, name="address", javaType=JGroupsAddress.class)
    public Address getAddress() {
        return this.address;
    }

    public static CommandInvocationId generateId(Address address) {
        return new CommandInvocationId(address, nextId.getAndIncrement());
    }

    public static CommandInvocationId generateIdFrom(CommandInvocationId commandInvocationId) {
        return new CommandInvocationId(commandInvocationId.address, nextId.getAndIncrement());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandInvocationId that = (CommandInvocationId)o;
        return this.id == that.id && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "CommandInvocation:" + Objects.toString(this.address, "local") + ":" + this.id;
    }

    public static String show(CommandInvocationId id) {
        return id == DUMMY_INVOCATION_ID ? "" : id.toString();
    }
}

