/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.logging.Log;

public abstract class BaseRpcInterceptor
extends DDAsyncInterceptor {
    protected final boolean trace = this.getLog().isTraceEnabled();
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected ComponentRegistry componentRegistry;
    protected boolean defaultSynchronous;

    protected abstract Log getLog();

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasAnyFlag(FlagBitSets.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL);
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        if (!ctx.isOriginLocal()) {
            return false;
        }
        LocalTxInvocationContext localCtx = (LocalTxInvocationContext)ctx;
        if (((LocalTransaction)localCtx.getCacheTransaction()).getStateTransferFlag() == Flag.PUT_FOR_STATE_TRANSFER) {
            return false;
        }
        boolean bl = shouldInvokeRemotely = ctx.hasModifications() || !localCtx.getRemoteLocksAcquired().isEmpty() || ((LocalTransaction)localCtx.getCacheTransaction()).getTopologyId() != this.rpcManager.getTopologyId();
        if (this.trace) {
            this.getLog().tracef("Should invoke remotely? %b. hasModifications=%b, hasRemoteLocksAcquired=%b", shouldInvokeRemotely, ctx.hasModifications(), !localCtx.getRemoteLocksAcquired().isEmpty());
        }
        return shouldInvokeRemotely;
    }

    protected static void transactionRemotelyPrepared(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markPrepareSent();
        }
    }

    protected boolean shouldLoad(InvocationContext ctx, FlagAffectedCommand command, DistributionInfo info) {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            return false;
        }
        VisitableCommand.LoadType loadType = command.loadType();
        switch (loadType) {
            case DONT_LOAD: {
                return false;
            }
            case OWNER: {
                return info.isPrimary() || info.isWriteOwner() && !ctx.isOriginLocal();
            }
            case PRIMARY: {
                return info.isPrimary();
            }
        }
        throw new IllegalStateException();
    }
}

