/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.infinispan.security.CachePermission;
import org.infinispan.util.logging.Log;

public class CachePermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -3709477547317792941L;
    private final List<Permission> perms = new ArrayList<Permission>();
    private int mask = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (permission.getClass() != CachePermission.class) {
            throw Log.SECURITY.invalidPermission(permission);
        }
        if (this.isReadOnly()) {
            throw Log.SECURITY.readOnlyPermissionCollection();
        }
        CachePermission p = (CachePermission)permission;
        CachePermissionCollection cachePermissionCollection = this;
        synchronized (cachePermissionCollection) {
            this.perms.add(p);
            this.mask |= p.getAuthorizationPermission().getMask();
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || !permission.getClass().equals(CachePermission.class)) {
            return false;
        }
        CachePermission p = (CachePermission)permission;
        return p.getAuthorizationPermission().matches(this.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        CachePermissionCollection cachePermissionCollection = this;
        synchronized (cachePermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }
}

