/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=129)
public class XidImpl
implements Xid {
    @ProtoField(value=1)
    final int formatId;
    @ProtoField(value=2)
    final byte[] rawId;
    private transient int cachedHashCode;

    protected XidImpl(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatId = formatId;
        this.rawId = new byte[globalTransactionId.length + branchQualifier.length + 1];
        this.rawId[0] = (byte)(globalTransactionId.length + 1 & 0xFF);
        System.arraycopy(globalTransactionId, 0, this.rawId, 1, globalTransactionId.length);
        System.arraycopy(branchQualifier, 0, this.rawId, globalTransactionId.length + 1, branchQualifier.length);
    }

    @ProtoFactory
    XidImpl(int formatId, byte[] rawId) {
        this.formatId = formatId;
        this.rawId = rawId;
    }

    private static void validateArray(String name, byte[] array, int maxLength) {
        if (array.length < 1 || array.length > maxLength) {
            throw new IllegalArgumentException(name + " length should be between 1 and " + maxLength);
        }
    }

    public static XidImpl create(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        XidImpl.validateArray("GlobalTransactionId", globalTransactionId, 64);
        XidImpl.validateArray("BranchQualifier", branchQualifier, 64);
        return new XidImpl(formatId, globalTransactionId, branchQualifier);
    }

    public static XidImpl copy(Xid externalXid) {
        return externalXid instanceof XidImpl ? (XidImpl)externalXid : new XidImpl(externalXid.getFormatId(), externalXid.getGlobalTransactionId(), externalXid.getBranchQualifier());
    }

    public static String printXid(int formatId, byte[] globalTransaction, byte[] branchQualifier) {
        return "Xid{formatId=" + formatId + ", globalTransactionId=" + Util.toHexString(globalTransaction) + ",branchQualifier=" + Util.toHexString(branchQualifier) + "}";
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return Arrays.copyOfRange(this.rawId, this.globalIdOffset(), this.branchQualifierOffset());
    }

    public ByteBuffer getGlobalTransactionIdAsByteBuffer() {
        return ByteBuffer.wrap(this.rawId, this.globalIdOffset(), this.globalIdLength());
    }

    @Override
    public byte[] getBranchQualifier() {
        return Arrays.copyOfRange(this.rawId, this.branchQualifierOffset(), this.rawId.length);
    }

    public ByteBuffer getBranchQualifierAsByteBuffer() {
        return ByteBuffer.wrap(this.rawId, this.branchQualifierOffset(), this.branchQualifierLength());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof XidImpl) {
            return this.formatId == ((XidImpl)o).formatId && Arrays.equals(this.rawId, ((XidImpl)o).rawId);
        }
        if (o instanceof Xid) {
            if (this.formatId != ((Xid)o).getFormatId()) {
                return false;
            }
            int firstByteOfBranch = this.rawId[0] & 0xFF;
            return this.arraysEquals(((Xid)o).getGlobalTransactionId(), 1, firstByteOfBranch, firstByteOfBranch - 1) && this.arraysEquals(((Xid)o).getBranchQualifier(), firstByteOfBranch, this.rawId.length, this.rawId.length - firstByteOfBranch);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int result = this.formatId;
            for (int i = 1; i < this.rawId.length; ++i) {
                result = 37 * result + this.rawId[i];
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        int firstByteOfBranch = this.rawId[0] & 0xFF;
        return "Xid{formatId=" + this.formatId + ", globalTransactionId=" + Util.toHexString(this.rawId, 1, firstByteOfBranch) + ",branchQualifier=" + Util.toHexString(this.rawId, firstByteOfBranch, this.rawId.length) + "}";
    }

    protected int globalIdOffset() {
        return 1;
    }

    protected int globalIdLength() {
        return this.branchQualifierOffset() - 1;
    }

    protected int branchQualifierOffset() {
        return this.rawId[0] & 0xFF;
    }

    protected int branchQualifierLength() {
        return this.rawId.length - this.branchQualifierOffset();
    }

    protected byte[] rawData() {
        return this.rawId;
    }

    private boolean arraysEquals(byte[] other, int start, int end, int length) {
        if (other.length != length) {
            return false;
        }
        int i = start;
        int j = 0;
        while (i < end) {
            if (this.rawId[i] != other[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }
}

