/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Combinations {
    private Combinations() {
    }

    public static <T extends Enum<T>> List<Set<T>> combine(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Enum class must not be null");
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Provided class is not an enum: " + clazz.getName());
        }
        ArrayList<Set<T>> combinations = new ArrayList<Set<T>>();
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        int n = constants.length;
        for (int i = 0; i < 1 << n; ++i) {
            EnumSet<T> curr = EnumSet.noneOf(clazz);
            for (int j = 0; j < n; ++j) {
                if ((i & 1 << j) == 0) continue;
                curr.add(constants[j]);
            }
            combinations.add(curr);
        }
        return combinations;
    }
}

