/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdk21;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.commons.spi.ThreadCreator;

public class ThreadCreatorImpl
implements ThreadCreator {
    public Thread createThread(ThreadGroup group, Runnable runnable, boolean useVirtualThreads) {
        if (useVirtualThreads) {
            return Thread.ofVirtual().unstarted(runnable);
        }
        return new Thread(group, runnable);
    }

    public Optional<ExecutorService> newVirtualThreadPerTaskExecutor() {
        return Optional.of(Executors.newVirtualThreadPerTaskExecutor());
    }

    public boolean isVirtual(Thread thread) {
        return thread.isVirtual();
    }
}

