/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.util.function.Function;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.logging.Log;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=6303)
public class LockFunction
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Boolean> {
    private static final Log log = Log.getLog(LockFunction.class);
    private final String requestId;
    private final Address requestor;

    @ProtoFactory
    public LockFunction(String requestId, Address requestor) {
        this.requestId = requestId;
        this.requestor = requestor;
    }

    @ProtoField(value=1)
    String getRequestId() {
        return this.requestId;
    }

    @ProtoField(value=2)
    Address getRequestor() {
        return this.requestor;
    }

    @Override
    public Boolean apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        ClusteredLockValue lock = (ClusteredLockValue)entryView.find().orElseThrow(() -> log.lockDeleted());
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] lock request by reqId %s requestor %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestor);
        }
        if (lock.getState() == ClusteredLockState.RELEASED) {
            entryView.set((Object)new ClusteredLockValue(this.requestId, this.requestor, ClusteredLockState.ACQUIRED), new MetaParam.Writable[0]);
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] lock acquired by %s %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestor);
            }
            return Boolean.TRUE;
        }
        if (lock.getState() == ClusteredLockState.ACQUIRED && lock.getRequestId().equals(this.requestId) && lock.getOwner().equals((Object)this.requestor)) {
            log.tracef("LOCK[%s] lock already acquired by %s %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestor);
            return Boolean.TRUE;
        }
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] lock not available, owned by %s %s", ((ClusteredLockKey)entryView.key()).getName(), lock.getRequestId(), lock.getOwner());
        }
        return Boolean.FALSE;
    }
}

