/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Objects;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.logging.Log;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;

public final class EmbeddedClusteredLockManagerFactory {
    private static final Log log = Log.getLog(EmbeddedClusteredLockManagerFactory.class);

    private EmbeddedClusteredLockManagerFactory() {
    }

    public static ClusteredLockManager from(EmbeddedCacheManager cacheManager) {
        Objects.requireNonNull(cacheManager, "EmbeddedCacheManager can't be null.");
        if (!cacheManager.getCacheManagerConfiguration().isClustered()) {
            throw log.requireClustered();
        }
        return (ClusteredLockManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(ClusteredLockManager.class);
    }
}

