/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.logging.Log;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=6304)
public class UnlockFunction
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Boolean> {
    private static final Log log = Log.getLog(UnlockFunction.class);
    private final String requestId;
    private final Set<Address> requesters;

    public UnlockFunction(Address requestor) {
        this.requestId = null;
        this.requesters = Collections.singleton(requestor);
    }

    @ProtoFactory
    public UnlockFunction(String requestId, Set<Address> requesters) {
        this.requestId = requestId;
        this.requesters = requesters;
    }

    @ProtoField(value=1)
    String getRequestId() {
        return this.requestId;
    }

    @ProtoField(value=2)
    Set<Address> getRequesters() {
        return this.requesters;
    }

    @Override
    public Boolean apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        boolean ownerMatches;
        ClusteredLockValue lockValue;
        if (log.isTraceEnabled()) {
            log.tracef("Lock[%s] unlock request by reqId [%s] requestors %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requesters);
        }
        if ((lockValue = (ClusteredLockValue)entryView.find().orElseThrow(() -> log.lockDeleted())).getState() == ClusteredLockState.RELEASED) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock[%s] Already free. State[RELEASED], reqId [%s], owner [%s]", ((ClusteredLockKey)entryView.key()).getName(), lockValue.getRequestId(), lockValue.getOwner());
            }
            return Boolean.TRUE;
        }
        boolean requestIdMatches = this.requestId == null || lockValue.getRequestId() != null && lockValue.getRequestId().equals(this.requestId);
        boolean bl = ownerMatches = lockValue.getOwner() != null && this.requesters.contains(lockValue.getOwner());
        if (requestIdMatches && ownerMatches) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock[%s] Unlocked by reqId [%s] requestors %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requesters);
            }
            entryView.set((Object)ClusteredLockValue.INITIAL_STATE, new MetaParam.Writable[0]);
            return Boolean.TRUE;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Lock[%s] Unlock not possible by reqId [%s] requestors %s. Current State[ACQUIRED], reqId [%s], owner [%s]", new Object[]{((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requesters, lockValue.getRequestId(), lockValue.getOwner()});
        }
        return Boolean.FALSE;
    }
}

