/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.util.function.Function;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.functional.EntryView;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.logging.Log;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=6302)
public class IsLocked
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Boolean> {
    private static final Log log = (Log)LogFactory.getLog(IsLocked.class, Log.class);
    private final Address requestor;

    public IsLocked() {
        this.requestor = null;
    }

    @ProtoFactory
    public IsLocked(Address requestor) {
        this.requestor = requestor;
    }

    @ProtoField(value=1)
    Address getRequestor() {
        return this.requestor;
    }

    @Override
    public Boolean apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        ClusteredLockValue lock = (ClusteredLockValue)entryView.find().orElseThrow(log::lockDeleted);
        Boolean result = Boolean.FALSE;
        if (lock.getState() == ClusteredLockState.ACQUIRED && (this.requestor == null || lock.getOwner() != null && lock.getOwner().equals((Object)this.requestor))) {
            result = Boolean.TRUE;
        }
        return result;
    }
}

