/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.listener;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterEventGenerator;
import org.infinispan.counter.impl.listener.TopologyChangeListener;
import org.infinispan.counter.logging.Log;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.GLOBAL)
public class CounterManagerNotificationManager {
    private static final Log log = Log.getLog(CounterManagerNotificationManager.class);
    private final Map<ByteString, Holder> counters = new ConcurrentHashMap<ByteString, Holder>(32);
    private final CounterValueListener valueListener = new CounterValueListener();
    private final TopologyListener topologyListener = new TopologyListener();
    private volatile BlockingManager.BlockingExecutor userListenerExecutor;

    @Inject
    public void inject(BlockingManager blockingManager) {
        this.userListenerExecutor = blockingManager.limitedBlockingExecutor("counter-listener", 1);
    }

    @Stop
    public void stop() {
        this.counters.clear();
    }

    public void registerCounter(ByteString counterName, CounterEventGenerator generator, TopologyChangeListener topologyChangeListener) {
        if (this.counters.putIfAbsent(counterName, new Holder(generator, topologyChangeListener)) != null) {
            throw new IllegalStateException();
        }
    }

    public <T extends CounterListener> Handle<T> registerUserListener(ByteString counterName, T userListener) {
        ByRef handleByRef = new ByRef(null);
        this.counters.computeIfPresent(counterName, (name, holder) -> holder.addListener(userListener, handleByRef));
        return (Handle)handleByRef.get();
    }

    public CompletionStage<Void> registerCounterValueListener(Cache<? extends CounterKey, CounterValue> cache) {
        return this.valueListener.register(cache);
    }

    public CompletionStage<Void> registerTopologyListener(Cache<? extends CounterKey, CounterValue> cache) {
        return this.topologyListener.register(cache);
    }

    public void removeCounter(ByteString counterName) {
        this.counters.remove(counterName);
    }

    @Listener(clustered=true, observation=Listener.Observation.POST)
    private class CounterValueListener {
        final AtomicBoolean registered = new AtomicBoolean(false);

        private CounterValueListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void updateState(CacheEntryEvent<? extends CounterKey, CounterValue> event) {
            CounterKey key = (CounterKey)event.getKey();
            Holder holder = CounterManagerNotificationManager.this.counters.get(key.getCounterName());
            if (holder == null) {
                return;
            }
            CounterEventGenerator counterEventGenerator = holder.generator;
            synchronized (counterEventGenerator) {
                this.triggerUserListener(holder.userListeners, holder.generator.generate(key, (CounterValue)event.getValue()));
            }
        }

        private void triggerUserListener(List<CounterListenerResponse<?>> userListeners, CounterEvent event) {
            if (userListeners.isEmpty() || event == null) {
                return;
            }
            CounterManagerNotificationManager.this.userListenerExecutor.execute(() -> userListeners.forEach(l -> l.onUpdate(event)), (Object)event);
        }

        CompletionStage<Void> register(Cache<? extends CounterKey, CounterValue> cache) {
            if (this.registered.compareAndSet(false, true)) {
                return cache.addListenerAsync((Object)this);
            }
            return CompletableFutures.completedNull();
        }
    }

    @Listener(sync=false)
    private class TopologyListener {
        final AtomicBoolean registered = new AtomicBoolean(false);

        private TopologyListener() {
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<?, ?> event) {
            CounterManagerNotificationManager.this.counters.values().stream().map(Holder::getTopologyChangeListener).filter(Objects::nonNull).forEach(TopologyChangeListener::topologyChanged);
        }

        private CompletionStage<Void> register(Cache<?, ?> cache) {
            ClusteringConfiguration config = cache.getCacheConfiguration().clustering();
            if (config.cacheMode().isClustered() && this.registered.compareAndSet(false, true)) {
                return cache.addListenerAsync((Object)this);
            }
            return CompletableFutures.completedNull();
        }
    }

    private static class Holder {
        private final CounterEventGenerator generator;
        private final List<CounterListenerResponse<?>> userListeners;
        private final TopologyChangeListener topologyChangeListener;

        private Holder(CounterEventGenerator generator, TopologyChangeListener topologyChangeListener) {
            this.generator = generator;
            this.topologyChangeListener = topologyChangeListener;
            this.userListeners = new CopyOnWriteArrayList();
        }

        <T extends CounterListener> Holder addListener(T userListener, ByRef<Handle<T>> handleByRef) {
            CounterListenerResponse<T> handle = new CounterListenerResponse<T>(userListener, this);
            this.userListeners.add(handle);
            handleByRef.set(handle);
            return this;
        }

        <T extends CounterListener> void removeListener(CounterListenerResponse<T> userListener) {
            this.userListeners.remove(userListener);
        }

        TopologyChangeListener getTopologyChangeListener() {
            return this.topologyChangeListener;
        }
    }

    private static class CounterListenerResponse<T extends CounterListener>
    implements Handle<T>,
    CounterListener {
        private final T listener;
        private final Holder holder;

        private CounterListenerResponse(T listener, Holder holder) {
            this.listener = listener;
            this.holder = holder;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.holder.removeListener(this);
        }

        public void onUpdate(CounterEvent event) {
            try {
                this.listener.onUpdate(event);
            }
            catch (Throwable t) {
                log.warnf(t, "Exception while invoking listener %s", this.listener);
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterListenerResponse that = (CounterListenerResponse)o;
            return this.listener.equals(that.listener);
        }
    }
}

