/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.util.Optional;
import java.util.function.Function;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4009)
public class InitializeCounterFunction<K extends CounterKey>
implements Function<EntryView.ReadWriteEntryView<K, CounterValue>, CounterValue> {
    @ProtoField(value=1)
    final CounterConfiguration counterConfiguration;

    @ProtoFactory
    public InitializeCounterFunction(CounterConfiguration counterConfiguration) {
        this.counterConfiguration = counterConfiguration;
    }

    @Override
    public CounterValue apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        Optional currentValue = entryView.find();
        if (currentValue.isPresent()) {
            return (CounterValue)currentValue.get();
        }
        CounterValue newValue = CounterValue.newCounterValue(this.counterConfiguration);
        entryView.set((Object)newValue, new MetaParam.Writable[]{new CounterConfigurationMetaParam(this.counterConfiguration)});
        return newValue;
    }

    public String toString() {
        return "InitializeCounterFunction{counterConfiguration=" + String.valueOf(this.counterConfiguration) + "}";
    }
}

