/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.function.FunctionHelper;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4005)
public class CompareAndSwapFunction<K extends CounterKey>
extends BaseFunction<K, Object> {
    private static final Log log = (Log)LogFactory.getLog(CompareAndSwapFunction.class, Log.class);
    @ProtoField(value=1)
    final long expect;
    @ProtoField(value=2)
    final long value;

    @ProtoFactory
    public CompareAndSwapFunction(long expect, long value) {
        this.expect = expect;
        this.value = value;
    }

    @Override
    Object apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, CounterConfigurationMetaParam metadata) {
        return FunctionHelper.compareAndSwap(entryView, (CounterValue)entryView.get(), metadata, this.expect, this.value);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

