/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.form;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.client.rest.MultiPartRestEntity;
import org.infinispan.commons.dataconversion.MediaType;

public class MultiPartRestEntityJDK
implements MultiPartRestEntity {
    public static final String CRLF = "\r\n";
    public static final String DOUBLE_DASH = "--";
    private final List<PartsSpecification> partsSpecificationList = new ArrayList<PartsSpecification>();
    private final String boundary = UUID.randomUUID().toString();

    @Override
    public MultiPartRestEntityJDK addPart(String name, String value) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.TYPE.STRING;
        newPart.name = name;
        newPart.value = value;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    @Override
    public MultiPartRestEntityJDK addPart(String name, Path value, MediaType contentType) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.TYPE.FILE;
        newPart.name = name;
        newPart.path = value;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartRestEntityJDK addPart(String name, Supplier<InputStream> value, String filename, String contentType) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.TYPE.STREAM;
        newPart.name = name;
        newPart.stream = value;
        newPart.filename = filename;
        newPart.contentType = contentType;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    private void addFinalBoundaryPart() {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.TYPE.FINAL_BOUNDARY;
        newPart.value = DOUBLE_DASH + this.boundary + DOUBLE_DASH;
        this.partsSpecificationList.add(newPart);
    }

    @Override
    public HttpRequest.BodyPublisher bodyPublisher() {
        if (this.partsSpecificationList.isEmpty()) {
            throw new IllegalStateException("Must have at least one part to build multipart message.");
        }
        this.addFinalBoundaryPart();
        return HttpRequest.BodyPublishers.ofByteArrays(() -> new PartsIterator());
    }

    @Override
    public MediaType contentType() {
        return MediaType.fromString((String)("multipart/form-data; boundary=" + this.boundary));
    }

    static class PartsSpecification {
        TYPE type;
        String name;
        String value;
        Path path;
        Supplier<InputStream> stream;
        String filename;
        String contentType;

        PartsSpecification() {
        }

        public static enum TYPE {
            STRING,
            FILE,
            STREAM,
            FINAL_BOUNDARY;

        }
    }

    class PartsIterator
    implements Iterator<byte[]> {
        private final Iterator<PartsSpecification> it;
        private InputStream currentFileInput;
        private boolean done;
        private byte[] next;

        PartsIterator() {
            this.it = MultiPartRestEntityJDK.this.partsSpecificationList.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.computeNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.next == null) {
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] res = this.next;
            this.next = null;
            return res;
        }

        private byte[] computeNext() throws IOException {
            if (this.currentFileInput == null) {
                String contentType;
                long size;
                String filename;
                if (!this.it.hasNext()) {
                    return null;
                }
                PartsSpecification nextPart = this.it.next();
                if (PartsSpecification.TYPE.STRING.equals((Object)nextPart.type)) {
                    String part = MultiPartRestEntityJDK.DOUBLE_DASH + MultiPartRestEntityJDK.this.boundary + "\r\nContent-Disposition: form-data; name=" + nextPart.name + "\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n" + nextPart.value + MultiPartRestEntityJDK.CRLF;
                    return part.getBytes(StandardCharsets.UTF_8);
                }
                if (PartsSpecification.TYPE.FINAL_BOUNDARY.equals((Object)nextPart.type)) {
                    return nextPart.value.getBytes(StandardCharsets.UTF_8);
                }
                if (PartsSpecification.TYPE.FILE.equals((Object)nextPart.type)) {
                    Path path = nextPart.path;
                    filename = path.getFileName().toString();
                    size = Files.size(path);
                    contentType = Files.probeContentType(path);
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    this.currentFileInput = Files.newInputStream(path, new OpenOption[0]);
                } else {
                    filename = nextPart.filename;
                    size = 0L;
                    contentType = nextPart.contentType;
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    this.currentFileInput = nextPart.stream.get();
                }
                String encoding = "text/plain".equals(contentType) ? "8bit" : "binary";
                String partHeader = MultiPartRestEntityJDK.DOUBLE_DASH + MultiPartRestEntityJDK.this.boundary + "\r\nContent-Disposition: form-data; name=" + nextPart.name + "; filename=" + filename + "\r\nContent-Type: " + contentType + "\r\nContent-Transfer-Encoding: " + encoding + MultiPartRestEntityJDK.CRLF + (String)(size == 0L ? "" : "Content-Length: " + size + MultiPartRestEntityJDK.CRLF) + MultiPartRestEntityJDK.CRLF;
                return partHeader.getBytes(StandardCharsets.UTF_8);
            }
            byte[] buf = new byte[8192];
            int r = this.currentFileInput.read(buf);
            if (r > 0) {
                byte[] actualBytes = new byte[r];
                System.arraycopy(buf, 0, actualBytes, 0, r);
                return actualBytes;
            }
            this.currentFileInput.close();
            this.currentFileInput = null;
            return MultiPartRestEntityJDK.CRLF.getBytes(StandardCharsets.UTF_8);
        }
    }
}

