/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.sse;

import java.io.Closeable;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.impl.jdk.RestResponseInfoJDK;
import org.infinispan.commons.dataconversion.MediaType;

public class EventSubscriber
implements Flow.Subscriber<String>,
Closeable {
    private Flow.Subscription subscription;
    private final List<String> lines = new ArrayList<String>();
    private final RestEventListener listener;
    private RestResponseInfoJDK responseInfo;

    public EventSubscriber(RestEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.listener.onOpen(this.responseInfo);
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(String line) {
        if (line.isEmpty()) {
            Map<String, String> map = this.lines.stream().map(l -> l.split(":", 2)).filter(pair -> !pair[0].isEmpty()).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1].trim(), String::concat));
            this.listener.onMessage(map.get("id"), map.get("event"), map.get("data"));
            this.lines.clear();
        } else {
            this.lines.add(line);
        }
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.subscription != null) {
            this.listener.onError(throwable, this.responseInfo);
        }
    }

    @Override
    public void onComplete() {
        this.subscription = null;
        this.listener.close();
    }

    @Override
    public void close() {
        Flow.Subscription sub = this.subscription;
        this.subscription = null;
        this.listener.close();
        if (sub != null) {
            sub.cancel();
        }
    }

    public HttpResponse.BodyHandler<Void> bodyHandler() {
        return responseInfo -> {
            this.responseInfo = new RestResponseInfoJDK(responseInfo);
            return HttpResponse.BodySubscribers.fromLineSubscriber(this, s -> null, EventSubscriber.charsetFrom(responseInfo.headers()), null);
        };
    }

    public static Charset charsetFrom(HttpHeaders headers) {
        String type = headers.firstValue("Content-type").orElse("text/html; charset=utf-8");
        MediaType mediaType = (MediaType)MediaType.parseList((String)type).findFirst().get();
        return mediaType.getCharset();
    }
}

