/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import java.util.Properties;
import javax.security.auth.Subject;
import org.infinispan.client.rest.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.SecurityConfigurationBuilder;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    private boolean enabled = false;
    private String mechanism;
    private Subject clientSubject;
    private String username;
    private char[] password;
    private String realm;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public AuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public AuthenticationConfigurationBuilder mechanism(String mechanism) {
        this.mechanism = mechanism;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.clientSubject = clientSubject;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.username = username;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.password = password != null ? password.toCharArray() : null;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password = password;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.realm = realm;
        return this.enable();
    }

    public AuthenticationConfiguration create() {
        String mech = this.mechanism == null ? "AUTO" : this.mechanism;
        return new AuthenticationConfiguration(this.clientSubject, this.enabled, mech, this.realm, this.username, this.password);
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.clientSubject = template.clientSubject();
        this.enabled = template.enabled();
        this.mechanism = template.mechanism();
        return this;
    }

    public void validate() {
    }

    @Override
    public RestClientConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Properties)properties);
        if (typed.containsKey((Object)"infinispan.client.rest.sasl_mechanism")) {
            this.mechanism(typed.getProperty("infinispan.client.rest.sasl_mechanism", this.mechanism, true));
        }
        if (typed.containsKey((Object)"infinispan.client.rest.auth_username")) {
            this.username(typed.getProperty("infinispan.client.rest.auth_username", this.username, true));
        }
        if (typed.containsKey((Object)"infinispan.client.rest.auth_password")) {
            this.password(typed.getProperty("infinispan.client.rest.auth_password", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.rest.auth_realm")) {
            this.realm(typed.getProperty("infinispan.client.rest.auth_realm", this.realm, true));
        }
        if (typed.containsKey((Object)"infinispan.client.rest.auth_client_subject")) {
            this.clientSubject((Subject)typed.get((Object)"infinispan.client.rest.auth_client_subject"));
        }
        if (typed.containsKey((Object)"infinispan.client.rest.use_auth")) {
            this.enabled(typed.getBooleanProperty("infinispan.client.rest.use_auth", this.enabled, true));
        }
        return this.builder.getBuilder();
    }
}

