/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransportObjectFactory
extends BaseKeyedPoolableObjectFactory {
    private static final Log log = LogFactory.getLog(TransportObjectFactory.class);
    private final TcpTransportFactory tcpTransportFactory;
    private final AtomicInteger topologyId;
    private final boolean pingOnStartup;
    private volatile boolean firstPingExecuted = false;

    public TransportObjectFactory(TcpTransportFactory tcpTransportFactory, AtomicInteger topologyId, boolean pingOnStartup) {
        this.tcpTransportFactory = tcpTransportFactory;
        this.topologyId = topologyId;
        this.pingOnStartup = pingOnStartup;
    }

    public Object makeObject(Object key) throws Exception {
        InetSocketAddress serverAddress = (InetSocketAddress)key;
        TcpTransport tcpTransport = new TcpTransport(serverAddress, this.tcpTransportFactory);
        if (log.isTraceEnabled()) {
            log.tracef("Created tcp transport: %s", (Object)tcpTransport);
        }
        if (this.pingOnStartup && !this.firstPingExecuted) {
            log.trace((Object)"Executing first ping!");
            this.firstPingExecuted = true;
            try {
                this.ping(tcpTransport, this.topologyId);
            }
            catch (Exception e) {
                log.tracef("Ignoring ping request failure during ping on startup: %s", (Object)e.getMessage());
            }
        }
        return tcpTransport;
    }

    private PingOperation.PingResult ping(TcpTransport tcpTransport, AtomicInteger topologyId) {
        PingOperation po = new PingOperation(topologyId, tcpTransport);
        return po.execute();
    }

    public boolean validateObject(Object key, Object obj) {
        TcpTransport transport = (TcpTransport)obj;
        if (log.isTraceEnabled()) {
            log.tracef("About to validate(ping) connection to server %s. TcpTransport is %s", key, (Object)transport);
        }
        return this.ping(transport, this.topologyId) == PingOperation.PingResult.SUCCESS;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("About to destroy tcp transport: %s", obj);
        }
        TcpTransport transport = (TcpTransport)obj;
        transport.destroy();
    }

    public void activateObject(Object key, Object obj) throws Exception {
        super.activateObject(key, obj);
        if (log.isTraceEnabled()) {
            log.tracef("Fetching from pool: %s", obj);
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        super.passivateObject(key, obj);
        if (log.isTraceEnabled()) {
            log.tracef("Returning to pool: %s", obj);
        }
    }
}

