/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.PropsKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class TcpTransportFactory
implements TransportFactory {
    private static final Log log = (Log)LogFactory.getLog(TcpTransportFactory.class, Log.class);
    private Object lock = new Object();
    private GenericKeyedObjectPool connectionPool;
    private RequestBalancingStrategy balancer;
    private Collection<InetSocketAddress> servers;
    private ConsistentHash consistentHash;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private volatile boolean tcpNoDelay;
    private volatile int soTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ConfigurationProperties cfg, Collection<InetSocketAddress> staticConfiguredServers, AtomicInteger topologyId) {
        Object object = this.lock;
        synchronized (object) {
            this.hashFactory.init(cfg);
            boolean pingOnStartup = cfg.getPingOnStartup();
            this.servers = Collections.unmodifiableCollection(new ArrayList<InetSocketAddress>(staticConfiguredServers));
            String balancerClass = cfg.getRequestBalancingStrategy();
            this.balancer = (RequestBalancingStrategy)Util.getInstance((String)balancerClass);
            this.tcpNoDelay = cfg.getTcpNoDelay();
            this.soTimeout = cfg.getSoTimeout();
            if (log.isDebugEnabled()) {
                log.debugf("Statically configured servers: %s", staticConfiguredServers);
                log.debugf("Load balancer class: %s", balancerClass);
                log.debugf("Tcp no delay = %b; client socket timeout = %d ms", this.tcpNoDelay, this.soTimeout);
            }
            PropsKeyedObjectPoolFactory poolFactory = new PropsKeyedObjectPoolFactory((KeyedPoolableObjectFactory)new TransportObjectFactory(this, topologyId, pingOnStartup), cfg.getProperties());
            this.createAndPreparePool(staticConfiguredServers, poolFactory);
            this.balancer.setServers(this.servers);
        }
    }

    private void createAndPreparePool(Collection<InetSocketAddress> staticConfiguredServers, PropsKeyedObjectPoolFactory poolFactory) {
        this.connectionPool = (GenericKeyedObjectPool)poolFactory.createPool();
        for (InetSocketAddress addr : staticConfiguredServers) {
            this.connectionPool.preparePool((Object)addr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.connectionPool.clear();
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                log.warn("Exception while shutting down the connection pool.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(LinkedHashMap<InetSocketAddress, Integer> servers2HashCode, int numKeyOwners, short hashFunctionVersion, int hashSpace) {
        Object object = this.lock;
        synchronized (object) {
            ConsistentHash hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(servers2HashCode, numKeyOwners, hashSpace);
            }
            this.consistentHash = hash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport() {
        InetSocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            server = this.balancer.nextServer();
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(byte[] key) {
        InetSocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            if (this.consistentHash != null) {
                server = this.consistentHash.getServer(key);
                if (log.isTraceEnabled()) {
                    log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
                }
            } else {
                server = this.balancer.nextServer();
                if (log.isTraceEnabled()) {
                    log.tracef("Using the balancer for determining the server: %s", server);
                }
            }
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTransport(Transport transport) {
        GenericKeyedObjectPool pool = this.getConnectionPool();
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (!tcpTransport.isValid()) {
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("Dropping connection as it is no longer valid: %s", tcpTransport);
                }
                pool.invalidateObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.couldNoInvalidateConnection(tcpTransport, e);
            }
        } else {
            try {
                pool.returnObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.couldNotReleaseConnection(tcpTransport, e);
            }
            finally {
                this.logConnectionInfo(tcpTransport.getServerAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServers(Collection<InetSocketAddress> newServers) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<InetSocketAddress> addedServers = new HashSet<InetSocketAddress>(newServers);
            addedServers.removeAll(this.servers);
            HashSet<InetSocketAddress> failedServers = new HashSet<InetSocketAddress>(this.servers);
            failedServers.removeAll(newServers);
            if (log.isTraceEnabled()) {
                log.tracef("Current list: %s", this.servers);
                log.tracef("New list: ", newServers);
                log.tracef("Added servers: ", addedServers);
                log.tracef("Removed servers: ", failedServers);
            }
            if (failedServers.isEmpty() && newServers.isEmpty()) {
                log.debug("Same list of servers, not changing the pool");
                return;
            }
            for (InetSocketAddress server : newServers) {
                log.newServerAdded(server);
                try {
                    this.connectionPool.addObject((Object)server);
                }
                catch (Exception e) {
                    log.failedAddingNewServer(server, e);
                }
            }
            this.balancer.setServers(newServers);
            for (InetSocketAddress server : failedServers) {
                log.removingServer(server);
                this.connectionPool.clear((Object)server);
            }
            this.servers = Collections.unmodifiableList(new ArrayList<InetSocketAddress>(newServers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InetSocketAddress> getServers() {
        Object object = this.lock;
        synchronized (object) {
            return this.servers;
        }
    }

    private void logConnectionInfo(InetSocketAddress server) {
        GenericKeyedObjectPool pool = this.getConnectionPool();
        if (log.isTraceEnabled()) {
            log.tracef("For server %s: active = %d; idle = %d", server, pool.getNumActive((Object)server), pool.getNumIdle((Object)server));
        }
    }

    private Transport borrowTransportFromPool(InetSocketAddress server) {
        GenericKeyedObjectPool pool = this.getConnectionPool();
        try {
            Transport transport = (Transport)pool.borrowObject((Object)server);
            return transport;
        }
        catch (Exception e) {
            String message = "Could not fetch transport";
            log.couldNotFetchTransport(e);
            throw new TransportException(message, e);
        }
        finally {
            this.logConnectionInfo(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistentHash getConsistentHash() {
        Object object = this.lock;
        synchronized (object) {
            return this.consistentHash;
        }
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransportCount() {
        if (Thread.currentThread().isInterrupted()) {
            return -1;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionPool.getMaxActive() > 0) {
                return this.connectionPool.getMaxActive() * this.servers.size();
            }
            return 10 * this.servers.size();
        }
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestBalancingStrategy getBalancer() {
        Object object = this.lock;
        synchronized (object) {
            return this.balancer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericKeyedObjectPool getConnectionPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionPool;
        }
    }
}

