/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspecException;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

@Immutable
public abstract class HotRodOperation
implements HotRodConstants {
    static final AtomicLong MSG_ID = new AtomicLong();
    private static final Log log = (Log)LogFactory.getLog(HotRodOperation.class, Log.class);
    protected final Flag[] flags;
    protected final byte[] cacheName;
    protected final AtomicInteger topologyId;
    private static final byte NO_TX = 0;
    private static final byte XA_TX = 1;

    protected HotRodOperation(Flag[] flags, byte[] cacheName, AtomicInteger topologyId) {
        this.flags = flags;
        this.cacheName = cacheName;
        this.topologyId = topologyId;
    }

    public abstract Object execute();

    protected final long writeHeader(Transport transport, short operationCode) {
        transport.writeByte((short)160);
        long messageId = MSG_ID.incrementAndGet();
        transport.writeVLong(messageId);
        transport.writeByte((short)10);
        transport.writeByte(operationCode);
        transport.writeArray(this.cacheName);
        int flagInt = 0;
        if (this.flags != null) {
            for (Flag flag : this.flags) {
                flagInt = flag.getFlagInt() | flagInt;
            }
        }
        transport.writeVInt(flagInt);
        transport.writeByte((short)3);
        transport.writeVInt(this.topologyId.get());
        transport.writeByte((short)0);
        if (log.isTraceEnabled()) {
            log.tracef("wrote header for message %d. Operation code: %#04x. Flags: %#x", messageId, operationCode, flagInt);
        }
        return messageId;
    }

    protected short readHeaderAndValidate(Transport transport, long messageId, short opRespCode) {
        short receivedOpCode;
        short magic = transport.readByte();
        boolean isTrace = log.isTraceEnabled();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            log.invalidMagicNumber((short)161, magic);
            if (isTrace) {
                log.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != messageId) {
            String message = "Invalid message id. Expected %d and received %d";
            log.invalidMessageId(messageId, receivedMessageId);
            if (isTrace) {
                log.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, messageId, receivedMessageId));
        }
        if (isTrace) {
            log.tracef("Received response for message id: %d", receivedMessageId);
        }
        if ((receivedOpCode = transport.readByte()) != opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport.readByte(), messageId, transport);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", opRespCode, receivedOpCode));
        }
        if (isTrace) {
            log.tracef("Received operation code is: %#04x", receivedOpCode);
        }
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport);
        return status;
    }

    protected void checkForErrorsInResponseStatus(short status, long messageId, Transport transport) {
        boolean isTrace = log.isTraceEnabled();
        if (isTrace) {
            log.tracef("Received operation status: %#x", status);
        }
        switch (status) {
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                this.readNewTopologyIfPresent(transport);
                String msgFromServer = transport.readString();
                if (status == 134 && isTrace) {
                    log.tracef("Server-side timeout performing operation: %s", msgFromServer);
                }
                if (msgFromServer.contains("SuspectException")) {
                    if (isTrace) {
                        log.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspecException(msgFromServer, messageId, status);
                }
                log.errorFromServer(msgFromServer);
                throw new HotRodClientException(msgFromServer, messageId, status);
            }
        }
        throw new IllegalStateException(String.format("Unknown status: %#04x", status));
    }

    private void readNewTopologyIfPresent(Transport transport) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, this.topologyId);
        }
    }

    private void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFunctionVersion = transport.readByte();
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        if (log.isTraceEnabled()) {
            log.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d", new Object[]{newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize});
        }
        LinkedHashMap<InetSocketAddress, Integer> servers2HashCode = new LinkedHashMap<InetSocketAddress, Integer>();
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            if (log.isTraceEnabled()) {
                log.tracef("Server read: %s:%d", host, port);
            }
            int hashCode = transport.read4ByteInt();
            servers2HashCode.put(new InetSocketAddress(host, port), hashCode);
            if (!log.isTraceEnabled()) continue;
            log.tracef("Hash code is: %d", hashCode);
        }
        if (log.isInfoEnabled()) {
            log.newTopology(servers2HashCode);
        }
        transport.getTransportFactory().updateServers(servers2HashCode.keySet());
        if (hashFunctionVersion == 0) {
            if (log.isTraceEnabled()) {
                log.trace("Not using a consistent hash function (hash function version == 0).");
            }
        } else {
            transport.getTransportFactory().updateHashFunction(servers2HashCode, numKeyOwners, hashFunctionVersion, hashSpace);
        }
    }
}

