/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.hash.MurmurHash2;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConsistentHashV1
implements ConsistentHash {
    private static final Log log = LogFactory.getLog(ConsistentHashV1.class);
    private final SortedMap<Integer, InetSocketAddress> positions = new TreeMap<Integer, InetSocketAddress>();
    private int hashSpace;
    protected Hash hash = new MurmurHash2();
    private int numKeyOwners;
    private Random rnd = new Random();

    @Override
    public void init(LinkedHashMap<InetSocketAddress, Integer> servers2HashCode, int numKeyOwners, int hashSpace) {
        for (InetSocketAddress addr : servers2HashCode.keySet()) {
            this.positions.put(servers2HashCode.get(addr), addr);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Positions are: %s", this.positions);
        }
        this.hashSpace = hashSpace;
        this.numKeyOwners = numKeyOwners;
    }

    @Override
    public InetSocketAddress getServer(byte[] key) {
        int keyHashCode = this.hash.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        int hash = Math.abs(keyHashCode);
        SortedMap<Integer, InetSocketAddress> candidates = this.positions.tailMap(hash % this.hashSpace);
        if (log.isTraceEnabled()) {
            log.tracef("Found possible candidates: %s", candidates);
        }
        int index = this.getIndex();
        if (candidates.size() <= index) {
            int newIndex = index - candidates.size();
            InetSocketAddress socketAddress = this.getItemAtPosition(newIndex, this.positions);
            if (log.isTraceEnabled()) {
                log.tracef("Over the wheel, returning member: %s", (Object)socketAddress);
            }
            return socketAddress;
        }
        InetSocketAddress socketAddress = this.getItemAtPosition(index, candidates);
        if (log.isTraceEnabled()) {
            log.tracef("Found candidate: %s", (Object)socketAddress);
        }
        return socketAddress;
    }

    private int getIndex() {
        return this.rnd.nextInt(Math.min(this.numKeyOwners, this.positions.size()));
    }

    private InetSocketAddress getItemAtPosition(int position, SortedMap<Integer, InetSocketAddress> map) {
        Iterator<Map.Entry<Integer, InetSocketAddress>> iterator = map.entrySet().iterator();
        for (int i = 0; i < position; ++i) {
            iterator.next();
        }
        return iterator.next().getValue();
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }
}

