/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.metrics.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.metrics.HotRodClientMetricsRegistry;
import org.infinispan.client.hotrod.metrics.RemoteCacheManagerMetricsRegistry;
import org.infinispan.client.hotrod.metrics.micrometer.MicrometerHotRodClientMetricRegistry;
import org.infinispan.commons.stat.CounterTracker;
import org.infinispan.commons.stat.DistributionSummaryTracker;
import org.infinispan.commons.stat.TimerTracker;

public class MicrometerRemoteCacheManagerMetricsRegistry
implements RemoteCacheManagerMetricsRegistry {
    private static final String DEFAULT_PREFIX = "client.hotrod";
    private static final String CACHE_PREFIX = "cache";
    private static final String CACHE_TAG = "cache";
    private final MicrometerHotRodClientMetricRegistry globalRegistry;
    private final Map<String, String> globalTags;
    private final Map<String, MicrometerHotRodClientMetricRegistry> cacheRegistry;

    private MicrometerRemoteCacheManagerMetricsRegistry(MeterRegistry registry, Map<String, String> globalTags, String prefix, boolean histograms) {
        this.globalTags = globalTags;
        this.globalRegistry = new MicrometerHotRodClientMetricRegistry(registry, this.globalTags, prefix, histograms);
        this.cacheRegistry = new ConcurrentHashMap<String, MicrometerHotRodClientMetricRegistry>();
    }

    @Override
    public HotRodClientMetricsRegistry withCache(String cacheName) {
        return this.cacheRegistry.computeIfAbsent(cacheName, this::createForCache);
    }

    @Override
    public void removeCache(String cacheName) {
        MicrometerHotRodClientMetricRegistry existing = this.cacheRegistry.remove(cacheName);
        if (existing != null) {
            existing.close();
        }
    }

    @Override
    public CounterTracker createCounter(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        return this.globalRegistry.createCounter(metricName, description, tags, generatedId);
    }

    @Override
    public DistributionSummaryTracker createDistributionSummery(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        return this.globalRegistry.createDistributionSummery(metricName, description, tags, generatedId);
    }

    @Override
    public void createGauge(String metricName, String description, Supplier<Number> gauge, Map<String, String> tags, Consumer<Object> generatedId) {
        this.globalRegistry.createGauge(metricName, description, gauge, tags, generatedId);
    }

    @Override
    public void createTimeGauge(String metricName, String description, Supplier<Number> gauge, TimeUnit timeUnit, Map<String, String> tags, Consumer<Object> generatedId) {
        this.globalRegistry.createTimeGauge(metricName, description, gauge, timeUnit, tags, generatedId);
    }

    @Override
    public TimerTracker createTimer(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        return this.globalRegistry.createTimer(metricName, description, tags, generatedId);
    }

    @Override
    public void close() {
        this.globalRegistry.close();
        this.cacheRegistry.values().forEach(MicrometerHotRodClientMetricRegistry::close);
        this.cacheRegistry.clear();
    }

    @Override
    public void removeMetric(Object id) {
        this.globalRegistry.removeMetric(id);
    }

    private MicrometerHotRodClientMetricRegistry createForCache(String cacheName) {
        String cachePrefix = this.globalRegistry.getPrefix() == null && this.globalRegistry.getPrefix().isEmpty() ? "cache" : this.globalRegistry.getPrefix() + ".cache";
        HashMap<String, String> cacheTags = new HashMap<String, String>(this.globalTags);
        cacheTags.put("cache", cacheName);
        return new MicrometerHotRodClientMetricRegistry(this.globalRegistry.getRegistry(), cacheTags, cachePrefix, this.globalRegistry.isHistogramEnabled());
    }

    public String toString() {
        return "MicrometerHotRodMetricRegistry{, globalRegistry=" + String.valueOf(this.globalRegistry) + ", globalTags=" + String.valueOf(this.globalTags) + "}";
    }

    public static class Builder {
        private final MeterRegistry registry;
        private final Map<String, String> tags;
        private String prefix = "client.hotrod";
        private boolean histograms = true;

        public Builder(MeterRegistry registry) {
            this.registry = Objects.requireNonNull(registry);
            this.tags = new HashMap<String, String>();
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withTag(String tagName, String tagValue) {
            this.tags.put(tagName, tagValue);
            return this;
        }

        public Builder clearTags() {
            this.tags.clear();
            return this;
        }

        public Builder withHistograms(boolean enabled) {
            this.histograms = enabled;
            return this;
        }

        public MicrometerRemoteCacheManagerMetricsRegistry build() {
            return new MicrometerRemoteCacheManagerMetricsRegistry(this.registry, Map.copyOf(this.tags), this.prefix, this.histograms);
        }
    }
}

